/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractLoader;
import weka.core.converters.BatchConverter;

public class TextDirectoryLoader
extends AbstractLoader
implements BatchConverter,
OptionHandler {
    private static final long serialVersionUID = 2592118773712247647L;
    protected Instances m_structure = null;
    protected File m_sourceFile = new File(System.getProperty("user.dir"));
    protected boolean m_Debug = false;
    protected boolean m_OutputFilename = false;

    public TextDirectoryLoader() {
        this.setRetrieval(0);
    }

    public String globalInfo() {
        return "Loads all text files in a directory and uses the subdirectory names as class labels. The content of the text files will be stored in a String attribute, the filename can be stored as well.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tEnables debug output.\n\t(default: off)", "D", 0, "-D"));
        vector.add(new Option("\tStores the filename in an additional attribute.\n\t(default: off)", "F", 0, "-F"));
        vector.add(new Option("\tThe directory to work on.\n\t(default: current directory)", "dir", 0, "-dir <directory>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag("D", stringArray));
        this.setOutputFilename(Utils.getFlag("F", stringArray));
        this.setDirectory(new File(Utils.getOption("dir", stringArray)));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getOutputFilename()) {
            vector.add("-F");
        }
        vector.add("-dir");
        vector.add(this.getDirectory().getAbsolutePath());
        return vector.toArray(new String[vector.size()]);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether to print additional debug information to the console.";
    }

    public void setOutputFilename(boolean bl) {
        this.m_OutputFilename = bl;
        this.reset();
    }

    public boolean getOutputFilename() {
        return this.m_OutputFilename;
    }

    public String outputFilenameTipText() {
        return "Whether to store the filename in an additional attribute.";
    }

    public String getFileDescription() {
        return "Directories";
    }

    public File getDirectory() {
        return new File(this.m_sourceFile.getAbsolutePath());
    }

    public void setDirectory(File file) throws IOException {
        this.setSource(file);
    }

    public void reset() {
        this.m_structure = null;
        this.setRetrieval(0);
    }

    public void setSource(File file) throws IOException {
        this.reset();
        if (file == null) {
            throw new IOException("Source directory object is null!");
        }
        this.m_sourceFile = file;
        if (!file.exists() || !file.isDirectory()) {
            throw new IOException("Directory '" + file + "' not found");
        }
    }

    public Instances getStructure() throws IOException {
        if (this.getDirectory() == null) {
            throw new IOException("No directory/source has been specified");
        }
        if (this.m_structure == null) {
            String string = this.getDirectory().getAbsolutePath();
            FastVector fastVector = new FastVector();
            FastVector fastVector2 = new FastVector();
            File file = new File(string);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + File.separator + stringArray[i]);
                if (!file2.isDirectory()) continue;
                fastVector2.addElement(stringArray[i]);
            }
            fastVector.addElement(new Attribute("text", (FastVector)null));
            if (this.m_OutputFilename) {
                fastVector.addElement(new Attribute("filename", (FastVector)null));
            }
            fastVector.addElement(new Attribute("class", fastVector2));
            String string2 = string.replaceAll("/", "_");
            string2 = string2.replaceAll("\\\\", "_").replaceAll(":", "_");
            this.m_structure = new Instances(string2, fastVector, 0);
            this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
        }
        return this.m_structure;
    }

    public Instances getDataSet() throws IOException {
        if (this.getDirectory() == null) {
            throw new IOException("No directory/source has been specified");
        }
        String string = this.getDirectory().getAbsolutePath();
        FastVector fastVector = new FastVector();
        Enumeration enumeration = this.getStructure().classAttribute().enumerateValues();
        while (enumeration.hasMoreElements()) {
            fastVector.addElement(enumeration.nextElement());
        }
        Instances instances = this.getStructure();
        int n = 0;
        for (int i = 0; i < fastVector.size(); ++i) {
            String string2 = (String)fastVector.elementAt(i);
            File file = new File(string + File.separator + string2);
            String[] stringArray = file.list();
            for (int j = 0; j < stringArray.length; ++j) {
                try {
                    int n2;
                    ++n;
                    if (this.getDebug()) {
                        System.err.println("processing " + n + " : " + string2 + " : " + stringArray[j]);
                    }
                    double[] dArray = null;
                    dArray = this.m_OutputFilename ? new double[3] : new double[2];
                    File file2 = new File(string + File.separator + string2 + File.separator + stringArray[j]);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n2 = bufferedInputStream.read()) != -1) {
                        stringBuffer.append((char)n2);
                    }
                    dArray[0] = instances.attribute(0).addStringValue(stringBuffer.toString());
                    if (this.m_OutputFilename) {
                        dArray[1] = instances.attribute(1).addStringValue(string2 + File.separator + stringArray[j]);
                    }
                    dArray[instances.classIndex()] = i;
                    instances.add(new Instance(1.0, dArray));
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("failed to convert file: " + string + File.separator + string2 + File.separator + stringArray[j]);
                }
            }
        }
        return instances;
    }

    public Instance getNextInstance(Instances instances) throws IOException {
        throw new IOException("TextDirectoryLoader can't read data sets incrementally.");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            try {
                TextDirectoryLoader textDirectoryLoader = new TextDirectoryLoader();
                textDirectoryLoader.setOptions(stringArray);
                System.out.println(textDirectoryLoader.getDataSet());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("\nUsage:\n\tTextDirectoryLoader [options]\n\nOptions:\n");
            Enumeration enumeration = new TextDirectoryLoader().listOptions();
            while (enumeration.hasMoreElements()) {
                Option option = (Option)enumeration.nextElement();
                System.err.println(option.synopsis());
                System.err.println(option.description());
            }
            System.err.println();
        }
    }
}

