/*
 * Decompiled with CFR 0.152.
 */
package thd;

import core.Annotation;
import core.Tag;
import core.TransformableItem;
import core.text.TextualItem;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import thd.Neighbor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThdMovieFragment
extends TextualItem {
    private static final long serialVersionUID = 2259360332156631817L;
    private static List<TransformableItem> allMovies = new ArrayList<TransformableItem>(400);

    public ThdMovieFragment() {
        allMovies.add(this);
    }

    public static void clear() {
        allMovies.clear();
    }

    public static int allMovieFragmentSize() {
        return allMovies.size();
    }

    public static List<TransformableItem> getAllMovieFragments() {
        return allMovies;
    }

    public static ThdMovieFragment movieFragmentAt(int i) {
        return (ThdMovieFragment)allMovies.get(i);
    }

    @Override
    public CharSequence CSVString(DefaultListModel items) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + "\t");
        if (this.father == null) {
            sb.append("-1\t");
        } else {
            sb.append(items.indexOf(this.father) + "\t");
        }
        for (Tag t : this.getTags()) {
            sb.append(String.valueOf(t.getName()) + ",");
        }
        sb.append("\t");
        return sb.toString();
    }

    @Override
    public List<TransformableItem> createVariations(int n) {
        return allMovies;
    }

    @Override
    public void initFromCSV(String[] feats) {
        this.name = this.stripQuotes(feats[0]);
        if (feats.length < 3) {
            return;
        }
        String[] stringArray = this.stripQuotes(feats[2]).split(",");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            this.tag(t);
            ++n;
        }
    }

    @Override
    public Tag tag(String s) {
        Tag t = super.tag(s);
        if (!this.textContains(this.text.split(","), s)) {
            if (!this.text.isEmpty()) {
                this.text = String.valueOf(this.text) + ", ";
            }
            this.text = String.valueOf(this.text) + s;
        }
        return t;
    }

    private boolean textContains(String[] strings, String s) {
        String[] stringArray = strings;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            if (t.equalsIgnoreCase(s)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    protected void randomize() {
    }

    @Override
    protected void setSonName(Annotation t, boolean moreOrLess, TransformableItem it) {
        if (moreOrLess) {
            it.setName(String.valueOf(it.getName()) + " (plus " + t.getName() + ")");
        } else {
            it.setName(String.valueOf(it.getName()) + " (moins " + t.getName() + ")");
        }
    }

    @Override
    public float distanceTo(TransformableItem m) {
        List<Tag> mTags = m.getTags();
        int commonTagNb = 0;
        for (Tag t : this.getTags()) {
            if (!mTags.contains(t)) continue;
            ++commonTagNb;
        }
        float sim = 2.0f * (float)commonTagNb / (float)(mTags.size() + this.getTags().size());
        return 1.0f - sim;
    }

    public Neighbor findNeighborMoreOf(Tag t, float ratio, boolean moreOrLess) {
        double initialBestValue;
        if (t == null) {
            return null;
        }
        List<TransformableItem> variations = this.createVariations(NB_VARIATIONS);
        this.sortByDistance(variations);
        double bestValue = initialBestValue = t.valueFor(this);
        System.out.println("look for fragment whose : " + t + " is " + (moreOrLess ? " > " : " < ") + initialBestValue * (double)(1.0f + ratio) + " (= " + ratio + "% better than " + initialBestValue);
        TransformableItem bestItem = null;
        int trial = -1;
        for (TransformableItem m : variations) {
            boolean foundBetter;
            ++trial;
            double val = t.valueFor(m);
            if (moreOrLess) {
                if (val > bestValue) {
                    bestValue = val;
                    bestItem = m;
                }
            } else if (val < bestValue) {
                bestValue = val;
                bestItem = m;
            }
            boolean bl = foundBetter = moreOrLess && val > initialBestValue * (double)(1.0f + ratio) || !moreOrLess && val < initialBestValue * (double)Math.max(0.5f, 1.0f - ratio);
            if (!foundBetter) continue;
            bestItem = m;
            return new Neighbor(this.getName(), bestItem.getName(), bestValue);
        }
        if (bestItem != null) {
            System.out.println("Found only slightly better ... ");
            return new Neighbor(this.getName(), bestItem.getName(), bestValue);
        }
        System.out.println("did not find ANY better");
        return null;
    }
}

