package csl.tools.parallel;

import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JPanel;
import javax.swing.JTextField;

public class ForPThreadActivityPane extends JPanel {

	private static final long		serialVersionUID	= -7641302080453146834L;
	private static final Color		INITIAL_COLOR		= Color.BLUE;
	private static final Color[]	STARTED_COLOR		= { Color.RED,
			new Color(185, 80, 80), new Color(125, 120, 120) };
	private static final Color		DONE_COLOR			= Color.GREEN;
	private JTextField				jTextField			= null;
	private int						colorIndex			= 0;

	/**
	 * This is the default constructor
	 */
	public ForPThreadActivityPane() {

		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		this.setLayout(new BorderLayout());
		this.setBackground(INITIAL_COLOR);
		this.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Thread", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", java.awt.Font.BOLD, 12), new java.awt.Color(51,51,51)));
		this.setSize(83, 20);
		this.add(getJTextField(), java.awt.BorderLayout.NORTH);
	}

	public void setCreated() {

		setBackground(INITIAL_COLOR);
		getJTextField().setText("WAITING");
	}

	public void setStarted() {

		setBackground(STARTED_COLOR[colorIndex]);
		getJTextField().setText("STARTED");
	}

	public void setDone() {

		setBackground(DONE_COLOR);
		getJTextField().setText("DONE");

	}

	public void blink() {

		setBackground(STARTED_COLOR[++colorIndex % STARTED_COLOR.length]);
	}

	/**
	 * This method initializes jTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getJTextField() {

		if (jTextField == null) {
			jTextField = new JTextField();
			jTextField.setEditable(false);
			jTextField.setText("WAITING");
		}
		return jTextField;
	}

} // @jve:decl-index=0:visual-constraint="10,10"
