/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.ConstrainAttributeDialog;
import core.FFVItem;
import core.Feature;
import core.JTreeSorter;
import core.Tag;
import core.TagCellRenderer;
import core.TransformableItem;
import csl.tools.files.FileTools;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import tangram.NeighborhoodExplorer;
import tangram.TTangram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformableItemFrame
extends JFrame {
    private static final long serialVersionUID = -7830852346901336365L;
    protected DefaultListModel items = new DefaultListModel();
    protected DefaultListModel tags = new DefaultListModel();
    private DefaultListModel features = new DefaultListModel();
    private DefaultListModel positiveExamples = new DefaultListModel();
    private DefaultListModel negativeExamples = new DefaultListModel();
    private JButton goButton = null;
    private JPanel mainPanel = null;
    private JScrollPane jScrollPane = null;
    private JPanel itemBtPanel = null;
    private JButton playButton = null;
    private JButton deleteButton = null;
    private JPanel featurePanel = null;
    private JTextArea tagTextArea = null;
    private JScrollPane jScrollPane1;
    private JButton avoidNegativeExamplejButton;
    private JPanel jPanel4;
    private JLabel negExampleLabel;
    private JLabel posExampleLabel;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane2;
    private JList negativeExamplesjList;
    private JList positiveExamplesjList;
    private JPanel jPanel1;
    private JTextArea tagjTextArea;
    private JPanel jPanel2;
    private JLabel jLabel = null;
    private JLabel featurejLabel = null;
    protected JList tagjList = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel12 = null;
    private JScrollPane tagListScrollPane = null;
    private JList featurejList = null;
    private JPanel jPanel3 = null;
    private JButton plusjButton = null;
    private JButton lessjButton = null;
    private JLabel jLabel13 = null;
    private JPanel tagBtPanel = null;
    private JButton learnjButton = null;
    private JCheckBox playSelectedCheckBox = null;
    private JButton moreTagButton = null;
    private JButton lessTagButton = null;
    private JButton saveButton = null;
    private JButton loadButton = null;
    private Checkbox showHideCheckbox = null;
    private JPanel moreLessBtFeaturePanel = null;
    private JPanel jPanel6 = null;
    protected JPanel itemlistPanel = null;
    protected JTree itemjTree = null;
    protected DefaultMutableTreeNode racine;
    protected DefaultTreeModel itemjTreeModel;
    private JButton clearButton = null;
    private JTextField moreOrLessField = null;
    private JTextField nbVariationsTextField = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel3 = null;
    private JButton constrainedjButton = null;
    public DefaultListModel lastContraintSet = null;
    protected JPanel dummyPanel = null;
    private Hashtable<TransformableItem, DefaultMutableTreeNode> itemsToTreeNodes = new Hashtable();
    private TagCellRenderer tagCellRenderer;
    protected JPanel specificButtonjPanel = null;
    private JTextField negativeTagjTextField = null;
    private JLabel jLabel4 = null;
    protected JComboBox sortByFeatureComboBox = null;
    private JPanel jPanel = null;
    private JComboBox sortByTagComboBox = null;
    private JPanel jPanel5 = null;
    private JLabel jLabel5 = null;
    private JPanel jPanel7 = null;
    private JLabel jLabel6 = null;
    private boolean isPopulatingComboBox;
    private JPopupMenu itemjPopupMenu = null;
    private JMenuItem tagItemjMenuItem = null;
    private JMenuItem clearTagItemjMenuItem = null;
    private JMenuItem renamejMenuItem = null;
    private JMenuItem copyMenuItem = null;
    private JMenuItem exploreMenuItem = null;
    private JButton sortAlphajButton = null;
    private JButton plusSliderjButton = null;
    private JButton minusSliderjButton = null;
    private JTextField repeatjTextField = null;
    private JButton repatMinusjButton = null;
    private JButton repeatPlusjButton = null;
    private JLabel jLabel7 = null;
    private JLabel jLabel8 = null;
    private JLabel jLabel9 = null;
    private JLabel jLabel10 = null;
    protected int repeatNb = 1;
    protected int improvementPercentage = 10;
    private JLabel jLabel11 = null;
    private JPanel negativejPanel8 = null;
    private Random random = new Random(7L);
    protected static String baseDirectory = "Sessions";

    public TransformableItemFrame() {
        this.initialize();
    }

    protected void play(TransformableItem item) {
    }

    private TransformableItem itemAt(int i) {
        return (TransformableItem)this.items.elementAt(i);
    }

    protected void initialize() {
        this.setSize(846, 662);
        this.setTitle("Transformable Item Game");
        this.setPreferredSize(new Dimension(1000, 800));
        this.setContentPane(this.getMainPanel());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.populateSortjComboBox();
    }

    protected void populateSortjComboBox() {
    }

    private JButton getGoButton() {
        if (this.goButton == null) {
            this.goButton = new JButton();
            this.goButton.setText("New");
            this.goButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.addRandomItem();
                }
            });
        }
        return this.goButton;
    }

    protected TransformableItem newRandomItem() {
        return null;
    }

    protected void addRandomItem() {
        this.addItem(this.newRandomItem());
    }

    protected void addItem(TransformableItem m) {
        this.addItemFrom(m, null);
    }

    protected DefaultMutableTreeNode addItemFrom(TransformableItem m, DefaultMutableTreeNode father) {
        return this.addItemFrom(m, father, true);
    }

    protected DefaultMutableTreeNode addItemFrom(TransformableItem m, DefaultMutableTreeNode father, boolean select) {
        this.items.addElement(m);
        DefaultMutableTreeNode parent = father;
        if (parent == null) {
            parent = this.racine;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(m);
        this.itemjTreeModel.insertNodeInto(newNode, parent, parent.getChildCount());
        this.itemsToTreeNodes.put(m, newNode);
        if (select) {
            this.selectNode(newNode);
        }
        return newNode;
    }

    private void selectNode(DefaultMutableTreeNode newNode) {
        TreePath path = new TreePath(this.itemjTreeModel.getPathToRoot(newNode));
        this.itemjTree.scrollPathToVisible(path);
        this.itemjTree.setSelectionPath(path);
    }

    private void removeItems() {
        TreePath[] paths = this.itemjTree.getSelectionPaths();
        int i = 0;
        while (i < paths.length) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            this.itemjTreeModel.removeNodeFromParent(node);
            this.removeItem((TransformableItem)node.getUserObject());
            ++i;
        }
        this.tagTextArea.setText("");
        this.refreshTaglist();
    }

    private void removeItem(TransformableItem it) {
        this.items.removeElement(it);
        this.removeAllItemsWhoseFatherIs(it);
    }

    /*
     * Unable to fully structure code
     */
    private void removeAllItemsWhoseFatherIs(TransformableItem it) {
        i = this.items.size() - 1;
        ** GOTO lbl10
        {
            --i;
            do {
                if (i > this.items.size()) continue block0;
                if (i < 0) break block0;
                if (((TransformableItem)this.items.elementAt(i)).getFather() == it) {
                    this.removeItem((TransformableItem)this.items.elementAt(i));
                }
                --i;
lbl10:
                // 2 sources

            } while (i >= 0);
        }
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            GridBagConstraints gridBagConstraints70 = new GridBagConstraints(2, 5, 2, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints70.gridy = 6;
            GridBagConstraints gridBagConstraints69 = new GridBagConstraints(0, 5, 1, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints69.gridy = 6;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.gridx = 2;
            gridBagConstraints24.fill = 1;
            gridBagConstraints24.gridwidth = 2;
            gridBagConstraints24.gridy = 4;
            GridBagConstraints gridBagConstraints54 = new GridBagConstraints(1, 5, 1, 4, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints54.gridheight = 3;
            gridBagConstraints54.weighty = 1.0;
            gridBagConstraints54.gridy = 7;
            GridBagConstraints gridBagConstraints47 = new GridBagConstraints();
            gridBagConstraints47.gridx = 0;
            gridBagConstraints47.fill = 1;
            gridBagConstraints47.gridy = 4;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.gridx = 1;
            gridBagConstraints41.fill = 1;
            gridBagConstraints41.gridheight = 3;
            gridBagConstraints41.weighty = 1.0;
            gridBagConstraints41.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 5;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 2;
            gridBagConstraints20.fill = 1;
            gridBagConstraints20.gridwidth = 2;
            gridBagConstraints20.gridy = 3;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 2;
            gridBagConstraints21.gridy = 4;
            gridBagConstraints21.gridwidth = 2;
            gridBagConstraints21.gridheight = 1;
            gridBagConstraints21.weighty = 0.105;
            gridBagConstraints21.fill = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 2;
            gridBagConstraints14.gridy = 2;
            this.jLabel13 = new JLabel();
            this.jLabel13.setText("Find");
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 1;
            gridBagConstraints15.gridy = 5;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.weighty = 1.0;
            gridBagConstraints15.gridx = 2;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 1;
            gridBagConstraints22.gridy = 2;
            this.jLabel12 = new JLabel();
            this.jLabel12.setText("Item view");
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.gridy = 2;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 2;
            gridBagConstraints17.gridy = 2;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 2;
            gridBagConstraints18.gridy = 0;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 1;
            gridBagConstraints13.fill = 1;
            gridBagConstraints13.weightx = 1.0;
            gridBagConstraints13.gridy = 5;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 1;
            gridBagConstraints1.gridy = -1;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            gridBagConstraints1.gridx = -1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 3;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.add((Component)this.getItemBtPanel(), gridBagConstraints7);
            this.mainPanel.add((Component)this.getFeaturePanel(), gridBagConstraints54);
            this.mainPanel.add((Component)this.jLabel2, gridBagConstraints19);
            this.mainPanel.add((Component)this.jLabel12, gridBagConstraints22);
            this.mainPanel.add((Component)this.getTagBtPanel(), gridBagConstraints20);
            this.mainPanel.add((Component)this.getJPanel2(), gridBagConstraints70);
            this.mainPanel.add((Component)this.jLabel13, gridBagConstraints14);
            this.mainPanel.add((Component)this.getItemlistPanel(), gridBagConstraints69);
            this.mainPanel.add((Component)this.getDummyPanel(), gridBagConstraints41);
            this.mainPanel.add((Component)this.getJPanel(), gridBagConstraints47);
            this.mainPanel.add((Component)this.getLearnjButton(), gridBagConstraints24);
        }
        return this.mainPanel;
    }

    public void selectItem(TransformableItem m) {
        if (m == null) {
            this.selectNull();
            return;
        }
        int i = this.getFeaturejList().getSelectedIndex();
        this.features.removeAllElements();
        List<String> feats = m.getFeatureNamesAndValues();
        for (String f : feats) {
            this.features.addElement(f);
        }
        this.featurejList.setSelectedIndex(i);
        this.tagTextArea.setText(m.getTagList());
        this.tagCellRenderer.setItem(m);
        this.refreshTaglist();
        this.selectItemSpecificAction(m);
        if (this.playSelectedCheckBox.isSelected()) {
            this.play(m);
        }
    }

    protected void selectItemSpecificAction(TransformableItem m) {
    }

    protected void selectNull() {
    }

    public TransformableItem getSelectedItem() {
        if (this.itemjTree.getSelectionPath() == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.itemjTree.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return null;
        }
        Object o = node.getUserObject();
        if (o instanceof String) {
            return null;
        }
        return (TransformableItem)o;
    }

    protected DefaultMutableTreeNode getSelectedItemNode() {
        if (this.itemjTree.getSelectionPath() == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.itemjTree.getSelectionPath().getLastPathComponent();
    }

    protected List<TransformableItem> getSelectedItems() {
        TreePath[] paths = this.itemjTree.getSelectionPaths();
        ArrayList<TransformableItem> mots = new ArrayList<TransformableItem>(paths.length);
        int i = 0;
        while (i < paths.length) {
            mots.add((TransformableItem)((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject());
            ++i;
        }
        return mots;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getItemjTree());
        }
        return this.jScrollPane;
    }

    private JPanel getItemBtPanel() {
        if (this.itemBtPanel == null) {
            GridBagConstraints gridBagConstraints112 = new GridBagConstraints();
            gridBagConstraints112.gridx = 0;
            gridBagConstraints112.fill = 1;
            gridBagConstraints112.gridwidth = 4;
            gridBagConstraints112.gridy = 2;
            GridBagConstraints gridBagConstraints111 = new GridBagConstraints();
            gridBagConstraints111.gridx = 1;
            gridBagConstraints111.fill = 1;
            gridBagConstraints111.gridy = 1;
            GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
            gridBagConstraints28.gridx = 1;
            gridBagConstraints28.fill = 1;
            gridBagConstraints28.gridy = 0;
            GridBagConstraints gridBagConstraints110 = new GridBagConstraints();
            gridBagConstraints110.gridx = 0;
            gridBagConstraints110.fill = 1;
            gridBagConstraints110.gridy = 0;
            GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
            gridBagConstraints31.gridx = 3;
            gridBagConstraints31.gridy = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridy = 1;
            gridBagConstraints21.fill = 1;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("items");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.gridy = 1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            this.itemBtPanel = new JPanel();
            this.itemBtPanel.setLayout(new GridBagLayout());
            this.itemBtPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.itemBtPanel.add((Component)this.getGoButton(), gridBagConstraints21);
            this.itemBtPanel.add((Component)this.getPlayButton(), gridBagConstraints);
            this.itemBtPanel.add((Component)this.getDeleteButton(), gridBagConstraints8);
            this.itemBtPanel.add((Component)this.getPlaySelectedCheckBox(), gridBagConstraints31);
            this.itemBtPanel.add((Component)this.getSaveButton(), gridBagConstraints110);
            this.itemBtPanel.add((Component)this.getLoadButton(), gridBagConstraints28);
            this.itemBtPanel.add((Component)this.getClearButton(), gridBagConstraints111);
            this.itemBtPanel.add((Component)this.getSpecificButtonjPanel(), gridBagConstraints112);
        }
        return this.itemBtPanel;
    }

    private JButton getPlayButton() {
        if (this.playButton == null) {
            this.playButton = new JButton();
            this.playButton.setText("play");
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItem m = TransformableItemFrame.this.getSelectedItem();
                    if (m != null) {
                        TransformableItemFrame.this.play(m);
                    }
                }
            });
        }
        return this.playButton;
    }

    private JButton getDeleteButton() {
        if (this.deleteButton == null) {
            this.deleteButton = new JButton();
            this.deleteButton.setText("delete");
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItem m = TransformableItemFrame.this.getSelectedItem();
                    if (m == null) {
                        return;
                    }
                    TransformableItemFrame.this.removeItems();
                }
            });
        }
        return this.deleteButton;
    }

    private JPanel getFeaturePanel() {
        if (this.featurePanel == null) {
            GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
            gridBagConstraints33.gridx = 0;
            gridBagConstraints33.gridy = 0;
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 0;
            gridBagConstraints30.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.gridy = -1;
            GridBagConstraints gridBagConstraints29 = new GridBagConstraints();
            gridBagConstraints29.gridx = 0;
            gridBagConstraints29.gridy = 0;
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 1;
            gridBagConstraints25.gridy = 11;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.weighty = 1.0;
            gridBagConstraints25.gridx = 0;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.gridx = 0;
            gridBagConstraints26.gridy = 10;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.gridy = 6;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridy = 5;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.weighty = 1.0;
            gridBagConstraints11.gridx = 0;
            this.featurejLabel = new JLabel();
            this.featurejLabel.setText("features");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.gridy = 8;
            this.jLabel = new JLabel();
            this.jLabel.setText("tags");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 1;
            gridBagConstraints9.gridy = 9;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.gridx = 0;
            this.featurePanel = new JPanel();
            this.featurePanel.setLayout(new GridBagLayout());
            this.featurePanel.setBorder(BorderFactory.createLineBorder(SystemColor.activeCaption, 1));
            this.featurePanel.setPreferredSize(new Dimension(200, 200));
            this.featurePanel.add((Component)this.getJScrollPane1(), new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.featurePanel.add((Component)this.jLabel, gridBagConstraints10);
            this.featurePanel.add((Component)this.getFeaturejList(), new GridBagConstraints(0, 5, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.featurePanel.add((Component)this.getJPanel3(), gridBagConstraints23);
            this.featurePanel.add((Component)this.getMoreLessBtFeaturePanel(), gridBagConstraints30);
            this.featurePanel.add((Component)this.getJPanel6(), gridBagConstraints33);
        }
        return this.featurePanel;
    }

    private JTextArea getTagTextArea() {
        if (this.tagTextArea == null) {
            this.tagTextArea = new JTextArea();
            this.tagTextArea.setFont(new Font("Dialog", 0, 18));
            this.tagTextArea.setForeground(new Color(246, 76, 76));
            this.tagTextArea.setLineWrap(true);
            this.tagTextArea.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        TransformableItemFrame.this.parseTags();
                    }
                }
            });
        }
        return this.tagTextArea;
    }

    protected void parseTags() {
        List<TransformableItem> mots = this.getSelectedItems();
        for (TransformableItem m : mots) {
            StringTokenizer st = new StringTokenizer(this.tagTextArea.getText());
            m.clearTags();
            while (st.hasMoreTokens()) {
                Tag tag = m.tag(st.nextToken());
                m.addTag(tag);
                this.addTag(tag);
            }
        }
        this.itemjTree.repaint();
        this.refreshTaglist();
    }

    private void addTag(Tag tag) {
        if (!this.tags.contains(tag)) {
            this.tags.addElement(tag);
        }
    }

    private void addTags(List<Tag> tgs) {
        for (Tag t : tgs) {
            this.addTag(t);
        }
    }

    private JList getTagjList() {
        if (this.tagjList == null) {
            this.tagjList = new JList();
            this.tagCellRenderer = new TagCellRenderer(null);
            this.tagjList.setCellRenderer(this.tagCellRenderer);
            this.tagjList.setName("tagjList");
            this.tagjList.setFont(new Font("Dialog", 0, 18));
            this.tagjList.setForeground(new Color(246, 76, 76));
            this.tagjList.setModel(this.tags);
            this.tagjList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    Tag t = (Tag)TransformableItemFrame.this.getTagjList().getSelectedValue();
                    if (t != null) {
                        TransformableItemFrame.this.posExampleLabel.setText("Positive examples (" + t.getPositiveExamples().size() + ")");
                        TransformableItemFrame.this.negExampleLabel.setText("negative examples (" + t.getNegativeExamples().size() + ")");
                    }
                    if (!e.getValueIsAdjusting()) {
                        TransformableItemFrame.this.populateExampleLists(t);
                    }
                }
            });
        }
        return this.tagjList;
    }

    protected void populateExampleLists(Tag t) {
        this.positiveExamples.removeAllElements();
        this.negativeExamples.removeAllElements();
        if (t == null) {
            return;
        }
        this.tagjTextArea.setText("selected features:\r\n" + t.getSelectedFeatures());
        for (TransformableItem it : t.getPositiveExamples()) {
            this.positiveExamples.addElement(it);
        }
        for (TransformableItem it : t.getNegativeExamples()) {
            this.negativeExamples.addElement(it);
        }
    }

    protected void refreshTaglist() {
        Tag selectedTag = null;
        int itag = this.getTagjList().getSelectedIndex();
        if (itag >= 0) {
            selectedTag = (Tag)this.getTagjList().getSelectedValue();
        }
        this.tags.clear();
        int i = 0;
        while (i < this.items.size()) {
            this.addTags(this.itemAt(i).getTags());
            ++i;
        }
        this.sortTaglist();
        if (selectedTag != null) {
            this.getTagjList().setSelectedValue(selectedTag, true);
        }
    }

    protected void sortTaglist() {
        ArrayList<Tag> theTags = new ArrayList<Tag>();
        int i = 0;
        while (i < this.tags.size()) {
            theTags.add((Tag)this.tags.elementAt(i));
            ++i;
        }
        Collections.sort(theTags, new Comparator<Tag>(){

            @Override
            public int compare(Tag m1, Tag m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
        this.tags.removeAllElements();
        for (Tag t : theTags) {
            this.tags.addElement(t);
        }
    }

    private JScrollPane getTagListScrollPane() {
        if (this.tagListScrollPane == null) {
            this.tagListScrollPane = new JScrollPane();
            this.tagListScrollPane.setViewportView(this.getTagjList());
        }
        return this.tagListScrollPane;
    }

    private JList getFeaturejList() {
        if (this.featurejList == null) {
            this.featurejList = new JList();
            this.featurejList.setModel(this.features);
        }
        return this.featurejList;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
        }
        return this.jPanel3;
    }

    private JButton getPlusjButton() {
        if (this.plusjButton == null) {
            this.plusjButton = new JButton();
            this.plusjButton.setText("more");
            this.plusjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.createMoreItemFromFeature();
                }
            });
        }
        return this.plusjButton;
    }

    private void createMoreItemFromFeature() {
        FFVItem.computeMeansAndVariances(this.toVector(this.items));
        TransformableItem m = this.getSelectedItem().findMoreOf(new Feature(this.getSelectedFeatureName()), true);
        if (m != null) {
            this.addItemFrom(m, this.getSelectedItemNode());
        }
    }

    protected String getSelectedFeature() {
        int i = this.getFeaturejList().getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return (String)this.features.elementAt(i);
    }

    protected String getSelectedFeatureName() {
        String f = this.getSelectedFeature();
        if (f == null) {
            return null;
        }
        return f.substring(0, f.indexOf(":"));
    }

    protected Tag getSelectedTag() {
        int i = this.getTagjList().getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return (Tag)this.tags.elementAt(i);
    }

    private JButton getLessjButton() {
        if (this.lessjButton == null) {
            this.lessjButton = new JButton();
            this.lessjButton.setText("less");
            this.lessjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.createLessItemFromFeature();
                }
            });
        }
        return this.lessjButton;
    }

    private void createLessItemFromFeature() {
        FFVItem.computeMeansAndVariances(this.toVector(this.items));
        TransformableItem m = this.getSelectedItem().findMoreOf(new Feature(this.getSelectedFeatureName()), false);
        if (m != null) {
            this.addItemFrom(m, this.getSelectedItemNode());
        }
    }

    private JPanel getTagBtPanel() {
        if (this.tagBtPanel == null) {
            GridBagConstraints gridBagConstraints36 = new GridBagConstraints();
            gridBagConstraints36.gridx = 5;
            gridBagConstraints36.gridy = 3;
            this.jLabel11 = new JLabel();
            this.jLabel11.setText("%");
            GridBagConstraints gridBagConstraints65 = new GridBagConstraints();
            gridBagConstraints65.gridx = 1;
            gridBagConstraints65.fill = 1;
            gridBagConstraints65.weightx = 1.0;
            gridBagConstraints65.gridy = 0;
            this.jLabel10 = new JLabel();
            this.jLabel10.setText("Find");
            this.jLabel10.setFont(new Font("Dialog", 1, 14));
            GridBagConstraints gridBagConstraints64 = new GridBagConstraints();
            gridBagConstraints64.gridx = 1;
            gridBagConstraints64.gridy = 3;
            this.jLabel9 = new JLabel();
            this.jLabel9.setText("improve by");
            GridBagConstraints gridBagConstraints63 = new GridBagConstraints();
            gridBagConstraints63.gridx = 5;
            gridBagConstraints63.gridy = 1;
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("times");
            GridBagConstraints gridBagConstraints62 = new GridBagConstraints();
            gridBagConstraints62.gridx = 1;
            gridBagConstraints62.gridy = 1;
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("repeat");
            GridBagConstraints gridBagConstraints60 = new GridBagConstraints();
            gridBagConstraints60.gridx = 4;
            gridBagConstraints60.fill = 1;
            gridBagConstraints60.gridy = 1;
            GridBagConstraints gridBagConstraints59 = new GridBagConstraints();
            gridBagConstraints59.gridx = 2;
            gridBagConstraints59.fill = 1;
            gridBagConstraints59.gridy = 1;
            GridBagConstraints gridBagConstraints58 = new GridBagConstraints();
            gridBagConstraints58.fill = 2;
            gridBagConstraints58.gridy = 1;
            gridBagConstraints58.weightx = 1.0;
            gridBagConstraints58.gridx = 3;
            GridBagConstraints gridBagConstraints57 = new GridBagConstraints();
            gridBagConstraints57.gridx = 2;
            gridBagConstraints57.fill = 1;
            gridBagConstraints57.gridy = 3;
            GridBagConstraints gridBagConstraints56 = new GridBagConstraints();
            gridBagConstraints56.gridx = 4;
            gridBagConstraints56.fill = 1;
            gridBagConstraints56.gridy = 3;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 5;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints40 = new GridBagConstraints();
            gridBagConstraints40.gridx = 1;
            gridBagConstraints40.gridy = 5;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("explore");
            GridBagConstraints gridBagConstraints39 = new GridBagConstraints();
            gridBagConstraints39.gridx = 5;
            gridBagConstraints39.gridy = 5;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("variations");
            GridBagConstraints gridBagConstraints38 = new GridBagConstraints();
            gridBagConstraints38.fill = 2;
            gridBagConstraints38.gridy = 5;
            gridBagConstraints38.weightx = 1.0;
            gridBagConstraints38.gridx = 3;
            GridBagConstraints gridBagConstraints37 = new GridBagConstraints();
            gridBagConstraints37.fill = 2;
            gridBagConstraints37.gridy = 3;
            gridBagConstraints37.weightx = 1.0;
            gridBagConstraints37.gridx = 3;
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.gridx = 4;
            gridBagConstraints27.gridy = 0;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 3;
            gridBagConstraints16.gridy = 0;
            this.tagBtPanel = new JPanel();
            this.tagBtPanel.setLayout(new GridBagLayout());
            this.tagBtPanel.add((Component)this.getLessTagButton(), gridBagConstraints27);
            this.tagBtPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
            this.tagBtPanel.add((Component)this.getMoreOrLessField(), gridBagConstraints37);
            this.tagBtPanel.add((Component)this.getNbVariationsTextField(), gridBagConstraints38);
            this.tagBtPanel.add((Component)this.jLabel1, gridBagConstraints39);
            this.tagBtPanel.add((Component)this.jLabel3, gridBagConstraints40);
            this.tagBtPanel.add((Component)this.getConstrainedjButton(), gridBagConstraints6);
            this.tagBtPanel.add((Component)this.getMoreTagButton(), gridBagConstraints16);
            this.tagBtPanel.add((Component)this.getPlusSliderjButton(), gridBagConstraints56);
            this.tagBtPanel.add((Component)this.getMinusSliderjButton(), gridBagConstraints57);
            this.tagBtPanel.add((Component)this.getRepeatjTextField(), gridBagConstraints58);
            this.tagBtPanel.add((Component)this.getRepatMinusjButton(), gridBagConstraints59);
            this.tagBtPanel.add((Component)this.getRepeatPlusjButton(), gridBagConstraints60);
            this.tagBtPanel.add((Component)this.jLabel7, gridBagConstraints62);
            this.tagBtPanel.add((Component)this.jLabel8, gridBagConstraints63);
            this.tagBtPanel.add((Component)this.jLabel9, gridBagConstraints64);
            this.tagBtPanel.add((Component)this.jLabel10, gridBagConstraints65);
            this.tagBtPanel.add((Component)this.jLabel11, gridBagConstraints36);
        }
        return this.tagBtPanel;
    }

    private JButton getLearnjButton() {
        if (this.learnjButton == null) {
            this.learnjButton = new JButton();
            this.learnjButton.setText("learn");
            this.learnjButton.setFont(new Font("Dialog", 1, 18));
            this.learnjButton.setToolTipText("Retrain the classifiers corresponding to each tag, if they have enough training samples");
            this.learnjButton.setBackground(new Color(204, 102, 255));
            this.learnjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.learnAllTags();
                }
            });
        }
        return this.learnjButton;
    }

    protected void learnAllTags() {
        Tag.clearAllClassifiersAndTrainingSets();
        int i = 0;
        while (i < this.tags.size()) {
            this.learnTag((Tag)this.tags.elementAt(i));
            ++i;
        }
        this.getTagjList().repaint();
        this.populateSortByTagComboBox();
    }

    protected void learnTag(Tag tag) {
        TransformableItem m;
        System.out.println("learning " + tag);
        int i = 0;
        while (i < this.items.size()) {
            m = this.itemAt(i);
            if (m.hasTag(tag)) {
                tag.addPositiveExample(m);
            }
            ++i;
        }
        if (tag.getNegativeTag() != null) {
            i = 0;
            while (i < this.items.size()) {
                m = this.itemAt(i);
                if (m.hasTag(tag.getNegativeTag())) {
                    tag.addNegativeExample(m);
                }
                if (tag.getNbNegativeExamples() > tag.getNbPositiveExamples()) break;
                ++i;
            }
        }
        while (tag.getNbNegativeExamples() < tag.getNbPositiveExamples()) {
            int ind = this.random.nextInt(this.items.size());
            TransformableItem randomItem = this.itemAt(ind);
            if (randomItem.hasTag(tag) || randomItem.getNbTags() <= 0 || !tag.acceptAsNegativeExample(randomItem)) continue;
            tag.addNegativeExample(randomItem);
        }
        if (tag.getPositiveExamples().size() == 0) {
            System.out.println("probleme, no positive example for " + tag + "!");
        } else {
            tag.train();
        }
    }

    public DefaultListModel getTags() {
        return this.tags;
    }

    private JCheckBox getPlaySelectedCheckBox() {
        if (this.playSelectedCheckBox == null) {
            this.playSelectedCheckBox = new JCheckBox();
            this.playSelectedCheckBox.setText("auto play");
            this.playSelectedCheckBox.setToolTipText("plays the selected item automatically, whatever this means");
            this.playSelectedCheckBox.setSelected(false);
        }
        return this.playSelectedCheckBox;
    }

    private JButton getMoreTagButton() {
        if (this.moreTagButton == null) {
            this.moreTagButton = new JButton();
            this.moreTagButton.setText("more");
            this.moreTagButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < TransformableItemFrame.this.repeatNb) {
                        TransformableItemFrame.this.createMoreItem(true);
                        ++i;
                    }
                }
            });
        }
        return this.moreTagButton;
    }

    protected List<TransformableItem> toVector(DefaultListModel itms) {
        ArrayList<TransformableItem> res = new ArrayList<TransformableItem>();
        int i = 0;
        while (i < itms.size()) {
            res.add((TransformableItem)itms.elementAt(i));
            ++i;
        }
        return res;
    }

    private JButton getLessTagButton() {
        if (this.lessTagButton == null) {
            this.lessTagButton = new JButton();
            this.lessTagButton.setText("less");
            this.lessTagButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int i = 0;
                    while (i < TransformableItemFrame.this.repeatNb) {
                        TransformableItemFrame.this.createMoreItem(false);
                        ++i;
                    }
                }
            });
        }
        return this.lessTagButton;
    }

    private void createMoreItem(boolean moreOrLess) {
        FFVItem.computeMeansAndVariances(this.toVector(this.items));
        if (this.getSelectedItem() == null || this.getSelectedTag() == null) {
            System.out.println("No tag or item selected");
            return;
        }
        TransformableItem m = this.getSelectedItem().findMoreOf(this.getSelectedTag(), moreOrLess);
        if (m != null) {
            this.addItemFrom(m, this.getSelectedItemNode());
        }
    }

    private JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton();
            this.saveButton.setText("save");
            this.saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.saveAll();
                }
            });
        }
        return this.saveButton;
    }

    protected void saveAllBinary() {
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(this.getSessionFileName(this), false));
            int i = 0;
            while (i < this.items.size()) {
                output.writeObject(this.itemAt(i));
                ++i;
            }
            output.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void saveAll() {
        if (this.items.size() == 0) {
            return;
        }
        File file = FileTools.chooseFile((String)this.getSessionFileName(this), (File)new File(baseDirectory));
        if (file == null) {
            return;
        }
        PrintWriter out = FileTools.printWriterOn((File)file);
        TransformableItem firstOne = (TransformableItem)this.items.elementAt(0);
        out.append(firstOne.getClass().getName());
        out.append("\r\n");
        int i = 0;
        while (i < this.items.size()) {
            out.append(this.itemAt(i).CSVString(this.items)).append("\r\n");
            ++i;
        }
        out.close();
    }

    private JButton getLoadButton() {
        if (this.loadButton == null) {
            this.loadButton = new JButton();
            this.loadButton.setText("load");
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.loadAll();
                }
            });
        }
        return this.loadButton;
    }

    protected String getSessionFileName(TransformableItemFrame f) {
        return String.valueOf(this.getClass().getSimpleName()) + ".csv";
    }

    protected void loadAll() {
        System.out.println("load file");
        Hashtable<TransformableItem, DefaultMutableTreeNode> nodes = new Hashtable<TransformableItem, DefaultMutableTreeNode>();
        try {
            File file = FileTools.chooseFile((String)this.getSessionFileName(this), (File)new File(baseDirectory));
            if (file == null) {
                return;
            }
            List lines = FileTools.readLines((File)file);
            String className = ((String)lines.get(0)).split(",")[0];
            Class<?> c = Class.forName(className);
            lines.remove(0);
            int cpt = 0;
            for (String line : lines) {
                if (cpt++ % 100 == 0) {
                    System.out.print(".");
                }
                TransformableItem m = (TransformableItem)c.newInstance();
                String[] tokens = line.split(",");
                m.initFromCSV(tokens);
                int fatherIndex = Integer.parseInt(tokens[1]);
                TransformableItem f = null;
                if (fatherIndex >= 0) {
                    f = (TransformableItem)this.items.elementAt(fatherIndex);
                }
                m.setFather(f);
                DefaultMutableTreeNode fatherNode = null;
                if (f != null) {
                    fatherNode = (DefaultMutableTreeNode)nodes.get(f);
                }
                DefaultMutableTreeNode newNode = this.addItemFrom(m, fatherNode, false);
                nodes.put(m, newNode);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        this.refreshTaglist();
        System.out.println("learn tags");
        this.learnAllTags();
        System.out.println("done");
    }

    protected void loadAllBinary() {
        ObjectInputStream input = null;
        Hashtable<TransformableItem, DefaultMutableTreeNode> nodes = new Hashtable<TransformableItem, DefaultMutableTreeNode>();
        try {
            input = new ObjectInputStream(new FileInputStream(this.getSessionFileName(this)));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            while (true) {
                TransformableItem m = (TransformableItem)input.readObject();
                TransformableItem f = m.getFather();
                DefaultMutableTreeNode father = null;
                if (f != null) {
                    father = (DefaultMutableTreeNode)nodes.get(f);
                }
                DefaultMutableTreeNode newNode = this.addItemFrom(m, father);
                nodes.put(m, newNode);
            }
        }
        catch (EOFException e) {
        }
        catch (Exception e) {
            System.out.println("exception in reading file");
            e.printStackTrace();
        }
        try {
            input.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("exception in trying to close");
        }
        this.refreshTaglist();
    }

    private Checkbox getShowHideCheckbox() {
        if (this.showHideCheckbox == null) {
            this.showHideCheckbox = new Checkbox();
            this.showHideCheckbox.setLabel("");
            this.showHideCheckbox.setState(true);
            this.showHideCheckbox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (TransformableItemFrame.this.showHideCheckbox.getState()) {
                        TransformableItemFrame.this.getFeaturejList().setVisible(true);
                        TransformableItemFrame.this.moreLessBtFeaturePanel.setVisible(true);
                    } else {
                        TransformableItemFrame.this.getFeaturejList().setVisible(false);
                        TransformableItemFrame.this.moreLessBtFeaturePanel.setVisible(false);
                    }
                }
            });
        }
        return this.showHideCheckbox;
    }

    private JPanel getMoreLessBtFeaturePanel() {
        if (this.moreLessBtFeaturePanel == null) {
            GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
            gridBagConstraints32.gridx = 2;
            gridBagConstraints32.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            this.moreLessBtFeaturePanel = new JPanel();
            this.moreLessBtFeaturePanel.setLayout(new GridBagLayout());
            this.moreLessBtFeaturePanel.add((Component)this.getLessjButton(), gridBagConstraints3);
            this.moreLessBtFeaturePanel.add((Component)this.getPlusjButton(), gridBagConstraints32);
        }
        return this.moreLessBtFeaturePanel;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            GridBagConstraints gridBagConstraints34 = new GridBagConstraints();
            gridBagConstraints34.gridx = 0;
            gridBagConstraints34.gridy = 0;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = -1;
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new GridBagLayout());
            this.jPanel6.add((Component)this.featurejLabel, gridBagConstraints12);
            this.jPanel6.add((Component)this.getShowHideCheckbox(), gridBagConstraints34);
        }
        return this.jPanel6;
    }

    private JPanel getItemlistPanel() {
        if (this.itemlistPanel == null) {
            GridBagConstraints gridBagConstraints35 = new GridBagConstraints();
            gridBagConstraints35.fill = 1;
            gridBagConstraints35.weighty = 1.0;
            gridBagConstraints35.weightx = 1.0;
            this.itemlistPanel = new JPanel();
            this.itemlistPanel.setLayout(new GridBagLayout());
            this.itemlistPanel.add((Component)this.getJScrollPane(), gridBagConstraints35);
        }
        return this.itemlistPanel;
    }

    private JTree getItemjTree() {
        if (this.itemjTree == null) {
            this.itemjTree = new JTree();
            this.itemjTree.setFont(new Font("Dialog", 1, 14));
            this.racine = new DefaultMutableTreeNode("All");
            this.itemjTreeModel = new DefaultTreeModel(this.racine);
            this.itemjTree.setModel(this.itemjTreeModel);
            this.itemjTree.setBorder(new LineBorder(new Color(0, 0, 0), 1, false));
            this.initItemJTree(this.itemjTree);
            this.itemjTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TransformableItemFrame.this.selectItem(TransformableItemFrame.this.getSelectedItem());
                }
            });
            this.itemjTree.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 127) {
                        TransformableItem m = TransformableItemFrame.this.getSelectedItem();
                        if (m == null) {
                            return;
                        }
                        TransformableItemFrame.this.removeItems();
                    }
                }
            });
            this.itemjTree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 3) {
                        TransformableItemFrame.this.getItemjPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
        return this.itemjTree;
    }

    protected void initItemJTree(JTree t) {
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("clear");
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.items.removeAllElements();
                    TransformableItemFrame.this.itemsToTreeNodes = new Hashtable();
                    TransformableItemFrame.this.racine = new DefaultMutableTreeNode("All");
                    TransformableItemFrame.this.itemjTreeModel = new DefaultTreeModel(TransformableItemFrame.this.racine);
                    TransformableItemFrame.this.itemjTree.setModel(TransformableItemFrame.this.itemjTreeModel);
                    Tag.clear();
                    TransformableItemFrame.this.refreshTaglist();
                }
            });
        }
        return this.clearButton;
    }

    private JTextField getMoreOrLessField() {
        if (this.moreOrLessField == null) {
            this.moreOrLessField = new JTextField();
            this.moreOrLessField.setText("10 %");
            this.moreOrLessField.setHorizontalAlignment(2);
            this.moreOrLessField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int improvmt = Integer.parseInt(TransformableItemFrame.this.moreOrLessField.getText());
                    if (improvmt <= 0) {
                        return;
                    }
                    TransformableItemFrame.this.improvementPercentage = improvmt;
                    TransformableItemFrame.this.moreOrLessField.setText(String.valueOf(TransformableItemFrame.this.improvementPercentage) + " %");
                    TransformableItem.setMoreOrLessRatio(TransformableItemFrame.this.improvementPercentage);
                }
            });
        }
        return this.moreOrLessField;
    }

    private JTextField getNbVariationsTextField() {
        if (this.nbVariationsTextField == null) {
            this.nbVariationsTextField = new JTextField();
            this.nbVariationsTextField.setText("2000");
            this.nbVariationsTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItem.setNbVariations(new Integer(TransformableItemFrame.this.nbVariationsTextField.getText()));
                }
            });
        }
        return this.nbVariationsTextField;
    }

    private JButton getConstrainedjButton() {
        if (this.constrainedjButton == null) {
            this.constrainedjButton = new JButton();
            this.constrainedjButton.setText("more | less");
            final TransformableItemFrame thisOne = this;
            this.constrainedjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (TransformableItemFrame.this.getSelectedItem() == null) {
                        return;
                    }
                    ConstrainAttributeDialog dial = new ConstrainAttributeDialog((Frame)thisOne, true, TransformableItemFrame.this.lastContraintSet);
                    dial.setLocation(TransformableItemFrame.this.getContentPane().getWidth() / 2, TransformableItemFrame.this.getContentPane().getHeight() / 2);
                    dial.setVisible(true);
                    if (dial.wasCancelled()) {
                        return;
                    }
                    if (dial.getConstraints() == null) {
                        return;
                    }
                    FFVItem.computeMeansAndVariances(TransformableItemFrame.this.toVector(TransformableItemFrame.this.items));
                    TransformableItemFrame.this.lastContraintSet = dial.getConstraints();
                    TransformableItem m = TransformableItemFrame.this.getSelectedItem().findConstrained(dial.getConstraints());
                    if (m != null) {
                        TransformableItemFrame.this.addItemFrom(m, TransformableItemFrame.this.getSelectedItemNode());
                    }
                }
            });
        }
        return this.constrainedjButton;
    }

    private JPanel getDummyPanel() {
        if (this.dummyPanel == null) {
            this.dummyPanel = new JPanel();
            this.dummyPanel.setLayout(new BorderLayout());
            this.dummyPanel.setMinimumSize(new Dimension(300, 100));
        }
        return this.dummyPanel;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.add((Component)this.getTagListScrollPane(), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel2.add((Component)this.getJPanel1(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel2.add((Component)this.getTagjTextArea(), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.jPanel2;
    }

    private JTextArea getTagjTextArea() {
        if (this.tagjTextArea == null) {
            this.tagjTextArea = new JTextArea();
            this.tagjTextArea.setText("");
        }
        return this.tagjTextArea;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints67 = new GridBagConstraints();
            gridBagConstraints67.gridx = 2;
            gridBagConstraints67.fill = 1;
            gridBagConstraints67.gridy = 1;
            GridBagConstraints gridBagConstraints66 = new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints66.weightx = 0.0;
            gridBagConstraints66.weighty = 0.0;
            GridBagConstraints gridBagConstraints45 = new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints45.gridx = 2;
            gridBagConstraints45.weightx = 0.0;
            gridBagConstraints45.weighty = 0.0;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("use negative tags");
            GridBagConstraints gridBagConstraints43 = new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints43.gridy = 4;
            gridBagConstraints43.gridx = 2;
            GridBagConstraints gridBagConstraints42 = new GridBagConstraints(0, 1, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints42.gridy = 4;
            gridBagConstraints42.weighty = 1.0;
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            jPanel1Layout.rowWeights = new double[]{0.1};
            jPanel1Layout.rowHeights = new int[]{7};
            jPanel1Layout.columnWeights = new double[]{0.1, 0.1};
            jPanel1Layout.columnWidths = new int[]{7, 7};
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.add((Component)this.getPosExampleLabel(), gridBagConstraints66);
            this.jPanel1.add((Component)this.getNegExampleLabel(), gridBagConstraints45);
            this.jPanel1.add((Component)this.getJScrollPane2(), gridBagConstraints42);
            this.jPanel1.add((Component)this.getJPanel4(), gridBagConstraints43);
            this.jPanel1.add((Component)this.getNegativejPanel8(), gridBagConstraints67);
        }
        return this.jPanel1;
    }

    private JList getPositiveExamplesjList() {
        if (this.positiveExamplesjList == null) {
            this.positiveExamplesjList = new JList();
            this.positiveExamplesjList.setSelectionMode(2);
            this.positiveExamplesjList.setModel(this.positiveExamples);
            this.positiveExamplesjList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    if (evt.getValueIsAdjusting()) {
                        return;
                    }
                    TransformableItem it = (TransformableItem)TransformableItemFrame.this.positiveExamplesjList.getSelectedValue();
                    if (it == null) {
                        return;
                    }
                    DefaultMutableTreeNode tn = (DefaultMutableTreeNode)TransformableItemFrame.this.itemsToTreeNodes.get(it);
                    if (tn == null) {
                        System.out.println("problem with this item!!");
                    }
                    TransformableItemFrame.this.selectNode(tn);
                    TransformableItemFrame.this.selectItem(it);
                }
            });
        }
        return this.positiveExamplesjList;
    }

    private JList getNegativeExamplesjList() {
        if (this.negativeExamplesjList == null) {
            this.negativeExamplesjList = new JList();
            this.negativeExamplesjList.setModel(this.negativeExamples);
            this.negativeExamplesjList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent evt) {
                    if (evt.getValueIsAdjusting()) {
                        return;
                    }
                    TransformableItem it = (TransformableItem)TransformableItemFrame.this.negativeExamplesjList.getSelectedValue();
                    if (it == null) {
                        return;
                    }
                    DefaultMutableTreeNode tn = (DefaultMutableTreeNode)TransformableItemFrame.this.itemsToTreeNodes.get(it);
                    if (tn == null) {
                        System.out.println("problem with this item!!");
                    }
                    TreePath path = new TreePath(TransformableItemFrame.this.itemjTreeModel.getPathToRoot(tn));
                    TransformableItemFrame.this.getItemjTree().scrollPathToVisible(path);
                    TransformableItemFrame.this.getItemjTree().setSelectionPath(path);
                    TransformableItemFrame.this.selectItem(it);
                }
            });
        }
        return this.negativeExamplesjList;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getPositiveExamplesjList());
        }
        return this.jScrollPane2;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setViewportView(this.getNegativeExamplesjList());
        }
        return this.jScrollPane3;
    }

    private JLabel getPosExampleLabel() {
        if (this.posExampleLabel == null) {
            this.posExampleLabel = new JLabel();
            this.posExampleLabel.setText("Positive Examples");
        }
        return this.posExampleLabel;
    }

    private JLabel getNegExampleLabel() {
        if (this.negExampleLabel == null) {
            this.negExampleLabel = new JLabel();
            this.negExampleLabel.setText("Negative Examples");
        }
        return this.negExampleLabel;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints61 = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
            gridBagConstraints61.weighty = 1.0;
            this.jPanel4 = new JPanel();
            GridBagLayout jPanel4Layout = new GridBagLayout();
            jPanel4Layout.rowWeights = new double[]{0.1, 0.1};
            jPanel4Layout.rowHeights = new int[]{7, 7};
            jPanel4Layout.columnWeights = new double[]{0.1, 0.1};
            jPanel4Layout.columnWidths = new int[]{7, 7};
            this.jPanel4.setLayout(jPanel4Layout);
            this.jPanel4.add((Component)this.getJScrollPane3(), gridBagConstraints61);
            this.jPanel4.add((Component)this.getAvoidNegativeExamplejButton(), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return this.jPanel4;
    }

    private JButton getAvoidNegativeExamplejButton() {
        if (this.avoidNegativeExamplejButton == null) {
            this.avoidNegativeExamplejButton = new JButton();
            this.avoidNegativeExamplejButton.setText("Avoid as counter example");
            this.avoidNegativeExamplejButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    Tag t = (Tag)TransformableItemFrame.this.getTagjList().getSelectedValue();
                    if (t == null) {
                        return;
                    }
                    TransformableItem it = (TransformableItem)TransformableItemFrame.this.getNegativeExamplesjList().getSelectedValue();
                    if (it == null) {
                        return;
                    }
                    t.addBadNegativeExample(it);
                    t.clearClassifierAndTrainingSet();
                    TransformableItemFrame.this.learnTag(t);
                    TransformableItemFrame.this.populateExampleLists(t);
                }
            });
        }
        return this.avoidNegativeExamplejButton;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getTagTextArea());
        }
        return this.jScrollPane1;
    }

    private JPanel getSpecificButtonjPanel() {
        if (this.specificButtonjPanel == null) {
            this.specificButtonjPanel = new JPanel();
            this.specificButtonjPanel.setLayout(new GridBagLayout());
        }
        return this.specificButtonjPanel;
    }

    private JTextField getNegativeTagjTextField() {
        if (this.negativeTagjTextField == null) {
            this.negativeTagjTextField = new JTextField();
            this.negativeTagjTextField.setText("negative_tags");
            this.negativeTagjTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.setNegativeTags();
                }
            });
        }
        return this.negativeTagjTextField;
    }

    protected void setNegativeTags() {
        int i = this.getTagjList().getSelectedIndex();
        if (i < 0) {
            return;
        }
        Tag t = (Tag)this.getTagjList().getSelectedValue();
        StringTokenizer st = new StringTokenizer(this.negativeTagjTextField.getText());
        Tag negTag = Tag.getTagNamed(st.nextToken());
        if (negTag == null) {
            System.out.println("negative tag does not exist");
            return;
        }
        t.setNegativeTag(negTag);
        t.clearClassifierAndTrainingSet();
        this.learnTag(t);
    }

    private JComboBox getSortByFeatureComboBox() {
        if (this.sortByFeatureComboBox == null) {
            this.sortByFeatureComboBox = new JComboBox();
            this.sortByFeatureComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new JTreeSorter((String)TransformableItemFrame.this.sortByFeatureComboBox.getSelectedItem()).sortByFeature((DefaultTreeModel)TransformableItemFrame.this.itemjTree.getModel(), TransformableItemFrame.this.racine);
                }
            });
        }
        return this.sortByFeatureComboBox;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints55 = new GridBagConstraints();
            gridBagConstraints55.gridx = 2;
            gridBagConstraints55.gridy = 1;
            GridBagConstraints gridBagConstraints46 = new GridBagConstraints();
            gridBagConstraints46.fill = 1;
            gridBagConstraints46.gridy = 1;
            gridBagConstraints46.weightx = 1.0;
            gridBagConstraints46.gridx = 1;
            GridBagConstraints gridBagConstraints48 = new GridBagConstraints();
            gridBagConstraints48.fill = 1;
            gridBagConstraints48.gridy = 0;
            gridBagConstraints48.weightx = 1.0;
            gridBagConstraints48.gridx = 1;
            GridBagConstraints gridBagConstraints53 = new GridBagConstraints();
            gridBagConstraints53.gridx = 2;
            gridBagConstraints53.gridy = 0;
            GridBagConstraints gridBagConstraints50 = new GridBagConstraints();
            gridBagConstraints50.gridx = 0;
            gridBagConstraints50.anchor = 17;
            gridBagConstraints50.gridy = 0;
            GridBagConstraints gridBagConstraints52 = new GridBagConstraints();
            gridBagConstraints52.gridx = 0;
            gridBagConstraints52.anchor = 17;
            gridBagConstraints52.gridy = 1;
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("sort by feature");
            this.jLabel6.setForeground(Color.pink);
            GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
            gridBagConstraints51.gridx = 1;
            gridBagConstraints51.gridy = 3;
            GridBagConstraints gridBagConstraints49 = new GridBagConstraints();
            gridBagConstraints49.gridx = 1;
            gridBagConstraints49.gridy = 2;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
            this.jPanel.add((Component)this.getJPanel5(), gridBagConstraints49);
            this.jPanel.add((Component)this.getJPanel7(), gridBagConstraints51);
            this.jPanel.add((Component)this.jLabel6, gridBagConstraints52);
            this.jPanel.add((Component)this.jLabel5, gridBagConstraints50);
            this.jPanel.add((Component)this.getSortByTagComboBox(), gridBagConstraints48);
            this.jPanel.add((Component)this.getSortByFeatureComboBox(), gridBagConstraints46);
            this.jPanel.add((Component)this.getSortAlphajButton(), gridBagConstraints55);
        }
        return this.jPanel;
    }

    private JComboBox getSortByTagComboBox() {
        if (this.sortByTagComboBox == null) {
            this.sortByTagComboBox = new JComboBox();
            this.sortByTagComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (TransformableItemFrame.this.isPopulatingComboBox) {
                        return;
                    }
                    new JTreeSorter((Tag)TransformableItemFrame.this.sortByTagComboBox.getSelectedItem()).sortByTag((DefaultTreeModel)TransformableItemFrame.this.itemjTree.getModel(), TransformableItemFrame.this.racine);
                }
            });
        }
        return this.sortByTagComboBox;
    }

    protected void populateSortByTagComboBox() {
        this.sortByTagComboBox.removeAllItems();
        this.isPopulatingComboBox = true;
        int i = 0;
        while (i < this.tags.size()) {
            this.getSortByTagComboBox().addItem(this.tags.elementAt(i));
            ++i;
        }
        this.isPopulatingComboBox = false;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("sort by tag");
            this.jLabel5.setForeground(Color.pink);
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new GridBagLayout());
        }
        return this.jPanel5;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new GridBagLayout());
        }
        return this.jPanel7;
    }

    private JPopupMenu getItemjPopupMenu() {
        if (this.itemjPopupMenu == null) {
            this.itemjPopupMenu = new JPopupMenu();
            this.itemjPopupMenu.add(this.getClearTagItemjMenuItem());
            this.itemjPopupMenu.add(this.getTagItemjMenuItem());
            this.itemjPopupMenu.add(this.getRenamejMenuItem());
            this.itemjPopupMenu.add(this.getCopyMenuItem());
            this.itemjPopupMenu.add(this.getExploreMenuItem());
        }
        return this.itemjPopupMenu;
    }

    private JMenuItem getTagItemjMenuItem() {
        if (this.tagItemjMenuItem == null) {
            this.tagItemjMenuItem = new JMenuItem();
            this.tagItemjMenuItem.setText("Tag");
            this.tagItemjMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String tagName = JOptionPane.showInputDialog("Enter a tag");
                    TransformableItemFrame.this.addTagToSeletedItems(Tag.named(tagName));
                }
            });
        }
        return this.tagItemjMenuItem;
    }

    private JMenuItem getClearTagItemjMenuItem() {
        if (this.clearTagItemjMenuItem == null) {
            this.clearTagItemjMenuItem = new JMenuItem();
            this.clearTagItemjMenuItem.setText("Clear Tags");
            this.clearTagItemjMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    List<TransformableItem> items = TransformableItemFrame.this.getSelectedItems();
                    for (TransformableItem m : items) {
                        m.clearTags();
                    }
                }
            });
        }
        return this.clearTagItemjMenuItem;
    }

    protected void addTagToSeletedItems(Tag t) {
        this.addTag(t);
        List<TransformableItem> mots = this.getSelectedItems();
        for (TransformableItem m : mots) {
            m.addTag(t);
        }
    }

    private JMenuItem getRenamejMenuItem() {
        if (this.renamejMenuItem == null) {
            this.renamejMenuItem = new JMenuItem();
            this.renamejMenuItem.setText("Rename");
            this.renamejMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItem item = TransformableItemFrame.this.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    String itemName = JOptionPane.showInputDialog("Enter a new name", (Object)item.getName());
                    TransformableItemFrame.this.renameSelectedItem(itemName);
                }
            });
        }
        return this.renamejMenuItem;
    }

    private JMenuItem getCopyMenuItem() {
        if (this.copyMenuItem == null) {
            this.copyMenuItem = new JMenuItem();
            this.copyMenuItem.setText("Duplicate");
            this.copyMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItem item = TransformableItemFrame.this.getSelectedItem();
                    if (item == null) {
                        return;
                    }
                    TransformableItemFrame.this.addItem(TransformableItemFrame.this.copyItem(item));
                }
            });
        }
        return this.copyMenuItem;
    }

    private JMenuItem getExploreMenuItem() {
        if (this.exploreMenuItem == null) {
            this.exploreMenuItem = new JMenuItem();
            this.exploreMenuItem.setText("Explore");
            this.exploreMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new NeighborhoodExplorer((TransformableItem)((TTangram)TransformableItemFrame.this.getSelectedItem())).setVisible(true);
                }
            });
        }
        return this.exploreMenuItem;
    }

    protected TransformableItem copyItem(TransformableItem item) {
        return null;
    }

    protected void renameSelectedItem(String itemName) {
        TransformableItem it = this.getSelectedItem();
        if (it == null) {
            return;
        }
        if (itemName == null) {
            return;
        }
        if (itemName.length() == 0) {
            return;
        }
        it.setName(itemName);
        TreePath path = this.itemjTree.getSelectionPath();
        this.itemjTree.setSelectionPath(null);
        this.itemjTree.setSelectionPath(path);
    }

    private JButton getSortAlphajButton() {
        if (this.sortAlphajButton == null) {
            this.sortAlphajButton = new JButton();
            this.sortAlphajButton.setText("a");
            this.sortAlphajButton.setFont(new Font("Ravie", 1, 12));
            this.sortAlphajButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    new JTreeSorter((String)TransformableItemFrame.this.sortByFeatureComboBox.getSelectedItem()).sortAlpha((DefaultTreeModel)TransformableItemFrame.this.itemjTree.getModel(), TransformableItemFrame.this.racine);
                }
            });
        }
        return this.sortAlphajButton;
    }

    private JButton getPlusSliderjButton() {
        if (this.plusSliderjButton == null) {
            this.plusSliderjButton = new JButton();
            this.plusSliderjButton.setText("+");
            this.plusSliderjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ++TransformableItemFrame.this.improvementPercentage;
                    TransformableItemFrame.this.moreOrLessField.setText(String.valueOf(TransformableItemFrame.this.improvementPercentage) + " %");
                    TransformableItem.setMoreOrLessRatio(TransformableItemFrame.this.improvementPercentage);
                }
            });
        }
        return this.plusSliderjButton;
    }

    private JButton getMinusSliderjButton() {
        if (this.minusSliderjButton == null) {
            this.minusSliderjButton = new JButton();
            this.minusSliderjButton.setText("-");
            this.minusSliderjButton.setPreferredSize(new Dimension(25, 26));
            this.minusSliderjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    --TransformableItemFrame.this.improvementPercentage;
                    TransformableItemFrame.this.moreOrLessField.setText(String.valueOf(TransformableItemFrame.this.improvementPercentage) + " %");
                    TransformableItem.setMoreOrLessRatio(TransformableItemFrame.this.improvementPercentage);
                }
            });
        }
        return this.minusSliderjButton;
    }

    private JTextField getRepeatjTextField() {
        if (this.repeatjTextField == null) {
            this.repeatjTextField = new JTextField();
            this.repeatjTextField.setText("1");
            this.repeatjTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TransformableItemFrame.this.repeatNb = Integer.parseInt(TransformableItemFrame.this.repeatjTextField.getText());
                }
            });
        }
        return this.repeatjTextField;
    }

    private JButton getRepatMinusjButton() {
        if (this.repatMinusjButton == null) {
            this.repatMinusjButton = new JButton();
            this.repatMinusjButton.setText("-");
            this.repatMinusjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    --TransformableItemFrame.this.repeatNb;
                    TransformableItemFrame.this.repeatjTextField.setText("" + TransformableItemFrame.this.repeatNb);
                }
            });
        }
        return this.repatMinusjButton;
    }

    private JButton getRepeatPlusjButton() {
        if (this.repeatPlusjButton == null) {
            this.repeatPlusjButton = new JButton();
            this.repeatPlusjButton.setText("+");
            this.repeatPlusjButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ++TransformableItemFrame.this.repeatNb;
                    TransformableItemFrame.this.repeatjTextField.setText("" + TransformableItemFrame.this.repeatNb);
                }
            });
        }
        return this.repeatPlusjButton;
    }

    private JPanel getNegativejPanel8() {
        if (this.negativejPanel8 == null) {
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints44 = new GridBagConstraints();
            gridBagConstraints44.gridx = -1;
            gridBagConstraints44.fill = 1;
            gridBagConstraints44.gridy = -1;
            this.negativejPanel8 = new JPanel();
            this.negativejPanel8.setLayout(new GridBagLayout());
            this.negativejPanel8.add((Component)this.jLabel4, gridBagConstraints44);
            this.negativejPanel8.add((Component)this.getNegativeTagjTextField(), gridBagConstraints2);
        }
        return this.negativejPanel8;
    }
}

