package csl.tools.algos;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class PathSearchAlgo<T> {

    private Hashtable<T, List<T>> transitions;

    public PathSearchAlgo(Hashtable<T, List<T>> transitions) {
        this.transitions = transitions;
    }

    public List<T> children(T t) {
        List<T> tval = transitions.get(t);
        if (tval == null)
            return new Vector<T>();
        return tval;
    }

    public List<T> ancestors(T t) {
        Enumeration<T> kEnum = transitions.keys();
        List<T> result = new Vector<T>();
        while (kEnum.hasMoreElements()) {
            T key = kEnum.nextElement();
            List<T> value = transitions.get(key);
            if (value.contains(t))
                result.add(key);
        }
        return result;
    }

    public List<T> ancestorsNotIn(T t, List<T> forbidden) {
        List<T> ancestors = ancestors(t);
        for (T ancestor : forbidden)
            ancestors.remove(ancestor);
        return ancestors;
    }

    public List<T> shortestPath(T src, T dest, List<T> forbidden) {
        if (src.equals(dest)) {
            Vector<T> res = new Vector<T>();
            res.add(src);
            res.add(dest);
            return res;
        }

        if (!forbidden.contains(dest))
            forbidden.add(dest);
        List<T> ancestors = ancestorsNotIn(dest, forbidden);
        if (ancestors.contains(src)) {
            Vector<T> res = new Vector<T>();
            res.add(src);
            res.add(dest);
            return res;
        }
        int shortestLength = Integer.MAX_VALUE;
        List<T> shortestPath = null;
        for (T ancestor : ancestors) {
            List<T> p = shortestPath(src, ancestor, forbidden);
            if (p != null && p.size() < shortestLength) {
                shortestLength = p.size();
                shortestPath = p;
            }
        }
        if (shortestPath != null)
            shortestPath.add(dest);
        return shortestPath;
    }

    public List<T> shortestPath(T src, T dest) {
        List<T> forbidden = new Vector<T>();
        return shortestPath(src, dest, forbidden);
    }
}
