/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintStream;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import weka.core.Tee;
import weka.core.Utils;
import weka.gui.LookAndFeel;

public class LogWindow
extends JFrame
implements CaretListener,
ChangeListener {
    private static final long serialVersionUID = 5650947361381061112L;
    public static final String STYLE_STDOUT = "stdout";
    public static final String STYLE_STDERR = "stderr";
    public static final Color COLOR_STDOUT = Color.BLACK;
    public static final Color COLOR_STDERR = Color.RED;
    public static final boolean DEBUG = false;
    public boolean m_UseWordwrap = true;
    protected JTextPane m_Output = new JTextPane();
    protected JButton m_ButtonClear = new JButton("Clear");
    protected JButton m_ButtonClose = new JButton("Close");
    protected JLabel m_LabelCurrentSize = new JLabel("currently: 0");
    protected JSpinner m_SpinnerMaxSize = new JSpinner();
    protected JCheckBox m_CheckBoxWordwrap = new JCheckBox("Use wordwrap");
    protected static Tee m_TeeOut = null;
    protected static Tee m_TeeErr = null;

    public LogWindow() {
        super("Weka - Log");
        boolean bl;
        this.createFrame();
        StyledDocument styledDocument = this.m_Output.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        style = styledDocument.addStyle(STYLE_STDOUT, style);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setForeground(style, COLOR_STDOUT);
        style = StyleContext.getDefaultStyleContext().getStyle("default");
        style = styledDocument.addStyle(STYLE_STDERR, style);
        StyleConstants.setFontFamily(style, "monospaced");
        StyleConstants.setForeground(style, COLOR_STDERR);
        boolean bl2 = bl = m_TeeOut != null || m_TeeErr != null;
        if (!bl) {
            m_TeeOut = new Tee(System.out);
            System.setOut(m_TeeOut);
        }
        m_TeeOut.add(new LogWindowPrintStream(this, m_TeeOut.getDefault(), STYLE_STDOUT));
        if (!bl) {
            m_TeeErr = new Tee(System.err);
            System.setErr(m_TeeErr);
        }
        m_TeeErr.add(new LogWindowPrintStream(this, m_TeeErr.getDefault(), STYLE_STDERR));
    }

    protected void createFrame() {
        this.setSize(600, 400);
        int n = this.getBounds().width;
        this.setLocation(this.getGraphicsConfiguration().getBounds().width - n, this.getLocation().y);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.m_Output), "Center");
        this.setWordwrap(this.m_UseWordwrap);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        jPanel2.add((Component)jPanel3, "East");
        this.m_ButtonClear.setMnemonic('C');
        this.m_ButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.clear();
            }
        });
        jPanel3.add(this.m_ButtonClear);
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LogWindow.this.close();
            }
        });
        jPanel3.add(this.m_ButtonClose);
        jPanel3 = new JPanel(new GridLayout(1, 3));
        jPanel2.add((Component)jPanel3, "West");
        JPanel jPanel4 = new JPanel(new FlowLayout());
        jPanel3.add(jPanel4);
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.m_SpinnerMaxSize.getModel();
        spinnerNumberModel.setMinimum(new Integer(1));
        spinnerNumberModel.setStepSize(new Integer(1000));
        spinnerNumberModel.setValue(new Integer(100000));
        spinnerNumberModel.addChangeListener(this);
        JLabel jLabel = new JLabel("max. Size");
        jLabel.setDisplayedMnemonic('m');
        jLabel.setLabelFor(this.m_SpinnerMaxSize);
        jPanel4.add(jLabel);
        jPanel4.add(this.m_SpinnerMaxSize);
        jPanel4 = new JPanel(new FlowLayout());
        jPanel3.add(jPanel4);
        jPanel4.add(this.m_LabelCurrentSize);
        jPanel4 = new JPanel(new FlowLayout());
        jPanel3.add(jPanel4);
        this.m_CheckBoxWordwrap.setSelected(this.m_UseWordwrap);
        this.m_CheckBoxWordwrap.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                LogWindow.this.setWordwrap(LogWindow.this.m_CheckBoxWordwrap.isSelected());
            }
        });
        jPanel4.add(this.m_CheckBoxWordwrap);
    }

    public void clear() {
        this.m_Output.setText("");
    }

    public void close() {
        this.setVisible(false);
    }

    public void trim() {
        int n;
        StyledDocument styledDocument = this.m_Output.getStyledDocument();
        int n2 = styledDocument.getLength();
        if (n2 > (n = ((Integer)this.m_SpinnerMaxSize.getValue()).intValue())) {
            try {
                int n3 = n2 - n;
                while (!styledDocument.getText(n3, 1).equals("\n")) {
                    ++n3;
                }
                while (styledDocument.getText(n3, 1).equals("\n")) {
                    ++n3;
                }
                styledDocument.remove(0, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_Output.setCaretPosition(styledDocument.getLength());
    }

    protected String colorToString(Color color) {
        String string = "#" + Utils.padLeft(Integer.toHexString(color.getRed()), 2) + Utils.padLeft(Integer.toHexString(color.getGreen()), 2) + Utils.padLeft(Integer.toHexString(color.getBlue()), 2);
        string = string.replaceAll("\\ ", "0").toUpperCase();
        return string;
    }

    public void setWordwrap(boolean bl) {
        this.m_UseWordwrap = bl;
        if (this.m_CheckBoxWordwrap.isSelected() != this.m_UseWordwrap) {
            this.m_CheckBoxWordwrap.setSelected(this.m_UseWordwrap);
        }
        Container container = this.m_Output.getParent();
        JTextPane jTextPane = this.m_Output;
        this.m_Output = this.m_UseWordwrap ? new JTextPane() : new JTextPane(){
            private static final long serialVersionUID = -8275856175921425981L;

            public void setSize(Dimension dimension) {
                if (dimension.width < this.getGraphicsConfiguration().getBounds().width) {
                    dimension.width = this.getGraphicsConfiguration().getBounds().width;
                }
                super.setSize(dimension);
            }

            public boolean getScrollableTracksViewportWidth() {
                return false;
            }
        };
        this.m_Output.setEditable(false);
        this.m_Output.addCaretListener(this);
        this.m_Output.setDocument(jTextPane.getDocument());
        this.m_Output.setCaretPosition(this.m_Output.getDocument().getLength());
        container.add(this.m_Output);
        container.remove(jTextPane);
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.m_LabelCurrentSize.setText("currently: " + this.m_Output.getStyledDocument().getLength());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.m_SpinnerMaxSize.getModel()) {
            this.trim();
            this.validate();
            this.caretUpdate(null);
        }
    }

    public static void main(String[] stringArray) {
        LookAndFeel.setLookAndFeel();
        LogWindow logWindow = new LogWindow();
        logWindow.setVisible(true);
        logWindow.setDefaultCloseOperation(2);
        System.out.print("a");
        System.err.print("a");
        System.out.print("a");
        System.out.println();
        System.err.println(new Date());
    }

    protected class LogWindowPrintStream
    extends PrintStream {
        protected LogWindow m_Parent;
        protected String m_Style;

        public LogWindowPrintStream(LogWindow logWindow2, PrintStream printStream, String string) {
            super(printStream);
            this.m_Parent = null;
            this.m_Style = null;
            this.m_Parent = logWindow2;
            this.m_Style = string;
        }

        public synchronized void flush() {
        }

        public synchronized void print(int n) {
            this.print(new Integer(n).toString());
        }

        public synchronized void print(boolean bl) {
            this.print(new Boolean(bl).toString());
        }

        public synchronized void print(String string) {
            StyledDocument styledDocument = this.m_Parent.m_Output.getStyledDocument();
            try {
                styledDocument.insertString(styledDocument.getLength(), string, styledDocument.getStyle(this.m_Style));
                this.m_Parent.m_Output.setCaretPosition(styledDocument.getLength());
                this.m_Parent.trim();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public synchronized void print(Object object) {
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                String string = throwable.getMessage() + "\n";
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    string = string + "\t" + stackTraceElementArray[i].toString() + "\n";
                }
                object = string;
            }
            this.print(object.toString());
        }

        public synchronized void println() {
            this.print("\n");
        }

        public synchronized void println(int n) {
            this.print(n);
            this.println();
        }

        public synchronized void println(boolean bl) {
            this.print(bl);
            this.println();
        }

        public synchronized void println(String string) {
            this.print(string);
            this.println();
        }

        public synchronized void println(Object object) {
            this.print(object);
            this.println();
        }
    }
}

