/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import weka.core.ClassDiscovery;

public class SerializationHelper {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static boolean isSerializable(String string) {
        boolean bl;
        try {
            bl = SerializationHelper.isSerializable(Class.forName(string));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean isSerializable(Class clazz) {
        return ClassDiscovery.hasInterface(Serializable.class, clazz);
    }

    public static boolean hasUID(String string) {
        boolean bl;
        try {
            bl = SerializationHelper.hasUID(Class.forName(string));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean hasUID(Class clazz) {
        boolean bl = false;
        if (SerializationHelper.isSerializable(clazz)) {
            try {
                clazz.getDeclaredField(SERIAL_VERSION_UID);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public static boolean needsUID(String string) {
        boolean bl;
        try {
            bl = SerializationHelper.needsUID(Class.forName(string));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static boolean needsUID(Class clazz) {
        boolean bl = SerializationHelper.isSerializable(clazz) ? !SerializationHelper.hasUID(clazz) : false;
        return bl;
    }

    public static long getUID(String string) {
        long l;
        try {
            l = SerializationHelper.getUID(Class.forName(string));
        }
        catch (Exception exception) {
            l = 0L;
        }
        return l;
    }

    public static long getUID(Class clazz) {
        return ObjectStreamClass.lookup(clazz).getSerialVersionUID();
    }

    public static void write(String string, Object object) throws Exception {
        SerializationHelper.write(new FileOutputStream(string), object);
    }

    public static void write(OutputStream outputStream, Object object) throws Exception {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        objectOutputStream.close();
    }

    public static Object read(String string) throws Exception {
        return SerializationHelper.read(new FileInputStream(string));
    }

    public static Object read(InputStream inputStream) throws Exception {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        return object;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("\nUsage: " + SerializationHelper.class.getName() + " classname [classname [classname [...]]]\n");
            System.exit(1);
        }
        System.out.println();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
            System.out.println("- is serializable: " + SerializationHelper.isSerializable(stringArray[i]));
            System.out.println("- has serialVersionUID: " + SerializationHelper.hasUID(stringArray[i]));
            System.out.println("- needs serialVersionUID: " + SerializationHelper.needsUID(stringArray[i]));
            System.out.println("- serialVersionUID: private static final long serialVersionUID = " + SerializationHelper.getUID(stringArray[i]) + "L;");
            System.out.println();
        }
    }
}

