/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.utilint.IdentityHashMap;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.RawAbstractInput;
import com.sleepycat.persist.raw.RawObject;
import java.util.Map;

class RecordOutput
extends TupleOutput
implements EntityOutput {
    private Catalog catalog;
    private boolean rawAccess;
    private Map<Object, Integer> visited;

    RecordOutput(Catalog catalog, boolean rawAccess) {
        this.catalog = catalog;
        this.rawAccess = rawAccess;
    }

    public void writeObject(Object o, Format fieldFormat) {
        Integer offset;
        if (o == null) {
            this.writePackedInt(0);
            return;
        }
        if (this.visited != null && (offset = this.visited.get(o)) != null) {
            if (offset == 0x7FFFFFFD) {
                throw new IllegalArgumentException("Cannot embed a reference to a proxied object in the proxy; for example, a collection may not be an element of the collection because collections are proxied");
            }
            this.writePackedInt(-(offset + 1));
            return;
        }
        Format format = this.rawAccess ? RawAbstractInput.checkRawType(this.catalog, o, fieldFormat) : this.catalog.getFormat(o.getClass(), false);
        if (format.getProxiedFormat() != null) {
            throw new IllegalArgumentException("May not store proxy classes directly: " + format.getClassName());
        }
        if (format.getEntityFormat() != null) {
            throw new IllegalArgumentException("References to entities are not allowed: " + o.getClass().getName());
        }
        if (this.visited == null) {
            this.visited = new IdentityHashMap<Object, Integer>();
        }
        boolean prohibitNestedRefs = format.areNestedRefsProhibited();
        Integer visitedOffset = this.size();
        this.visited.put(o, prohibitNestedRefs ? 0x7FFFFFFD : visitedOffset);
        this.writePackedInt(format.getId());
        format.writeObject(o, this, this.rawAccess);
        if (prohibitNestedRefs) {
            this.visited.put(o, visitedOffset);
        }
    }

    public void writeKeyObject(Object o, Format fieldFormat) {
        Format format;
        if (o == null) {
            throw new IllegalArgumentException("Key field object may not be null");
        }
        if (this.rawAccess) {
            if (o instanceof RawObject) {
                format = (Format)((RawObject)o).getType();
            } else {
                format = this.catalog.getFormat(o.getClass(), false);
                if (fieldFormat.isPrimitive()) {
                    fieldFormat = fieldFormat.getWrapperFormat();
                }
            }
        } else {
            format = this.catalog.getFormat(o.getClass(), false);
        }
        if (fieldFormat != format) {
            throw new IllegalArgumentException("The key field object class (" + o.getClass().getName() + ") must be the field's declared class: " + fieldFormat.getClassName());
        }
        fieldFormat.writeObject(o, this, this.rawAccess);
    }

    public void registerPriKeyObject(Object o) {
        if (this.visited == null) {
            this.visited = new IdentityHashMap<Object, Integer>();
        }
        this.visited.put(o, 0x7FFFFFFE);
    }

    public void writeArrayLength(int length) {
        this.writePackedInt(length);
    }

    public void writeEnumConstant(String[] names, int index) {
        this.writePackedInt(index);
    }
}

