package csl.tools.thread;

import java.util.concurrent.ExecutionException;

import javax.swing.JFrame;
import javax.swing.WindowConstants;

public class Test extends MyThreadStatusPane {

	private static final int	THREAD_COUNT		= Runtime.getRuntime().availableProcessors();
	private static final int	ITEM_COUNT			= 1000;
	private static final long	serialVersionUID	= 2592203313949145115L;

	public static void main(String[] args) throws InterruptedException,
			ExecutionException {

		JFrame f = new JFrame("Test Threads");
		f.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		MyThreadPool<Integer> pool = new MyThreadPool<Integer>();
		for (int i = 0; i < ITEM_COUNT; i++)
			pool.addItem(i);
		for (int i = 0; i < THREAD_COUNT; i++) {
			MyThread th = new MyThread();
			th.setPool(pool);
			pool.addThread(th);
		}
		MyThreadPoolPane p = new MyThreadPoolPane();
		p.setPool(pool);
		f.setContentPane(p);
		f.setVisible(true);
		long t0 = System.currentTimeMillis();
		pool.run();
		long t1 = System.currentTimeMillis();
		System.out.println("CPU: " + (t1 - t0));
		System.out.println("PROCESS COUNT: " + MyThread.processCount);
		System.out.println("DO IN BACKGROUND COUNT: "
				+ MyThread.doInBackgroundCount);
	}

}
