/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Tag;

public class TagConstraint {
    public static final int AS = 0;
    public static final int MORE = 1;
    public static final int LESS = 2;
    public static final int DONTCARE = 3;
    private Tag tag;
    private int constraintType = 0;
    private int ratio = 10;

    public TagConstraint(Tag t, int c, int r) {
        this.tag = t;
        this.constraintType = c;
        this.ratio = r;
    }

    private String getConstraintName() {
        if (this.constraintType == 0) {
            return "as";
        }
        if (this.constraintType == 1) {
            return "more";
        }
        if (this.constraintType == 2) {
            return "less";
        }
        if (this.constraintType == 3) {
            return "dontCare";
        }
        return "?";
    }

    public void setConstraintType(int ct) {
        this.constraintType = ct;
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public void setRatio(int r) {
        this.ratio = r;
    }

    public int getRatio() {
        return this.ratio;
    }

    public Tag getTag() {
        return this.tag;
    }

    public String toString() {
        if (this.constraintType == 3) {
            return "any " + this.tag.getName();
        }
        return String.valueOf(this.getConstraintName()) + " " + this.tag.getName() + " by " + this.ratio + "%";
    }

    public boolean isNotDontCare() {
        return this.getConstraintType() != 3;
    }

    public float getPercentage() {
        return (float)this.getRatio() / 100.0f;
    }
}

