/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.Vector;
import weka.clusterers.Clusterer;
import weka.clusterers.SimpleKMeans;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class SingleClustererEnhancer
extends Clusterer
implements OptionHandler {
    private static final long serialVersionUID = 4893928362926428671L;
    protected Clusterer m_Clusterer = new SimpleKMeans();

    protected String defaultClustererString() {
        return SimpleKMeans.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tFull name of base clusterer.\n\t(default: " + this.defaultClustererString() + ")", "W", 1, "-W"));
        if (this.m_Clusterer instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to clusterer " + this.m_Clusterer.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_Clusterer)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            this.setClusterer(Clusterer.forName(string, null));
            this.setClusterer(Clusterer.forName(string, Utils.partitionOptions(stringArray)));
        } else {
            this.setClusterer(Clusterer.forName(this.defaultClustererString(), null));
            this.setClusterer(Clusterer.forName(this.defaultClustererString(), Utils.partitionOptions(stringArray)));
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-W");
        vector.add(this.getClusterer().getClass().getName());
        if (this.getClusterer() instanceof OptionHandler) {
            vector.add("--");
            String[] stringArray = ((OptionHandler)((Object)this.getClusterer())).getOptions();
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String clustererTipText() {
        return "The base clusterer to be used.";
    }

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    protected String getClustererSpec() {
        Clusterer clusterer = this.getClusterer();
        String string = clusterer.getClass().getName();
        if (clusterer instanceof OptionHandler) {
            string = string + " " + Utils.joinOptions(((OptionHandler)((Object)clusterer)).getOptions());
        }
        return string;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getClusterer() == null ? super.getCapabilities() : this.getClusterer().getCapabilities();
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        return capabilities;
    }

    public int numberOfClusters() throws Exception {
        return this.m_Clusterer.numberOfClusters();
    }
}

