package csl.tools.thread;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutionException;

public class MyThreadPool<T> {

	private List<MyThread>			threads;
	private List<T>					items;
	private List<MyThreadPoolPane>	listeners;

	public MyThreadPool() {

		super();
		listeners = new Vector<MyThreadPoolPane>();
		threads = new Vector<MyThread>();
		items = new Vector<T>();
	}

	public void addThread(MyThread th) {

		threads.add(th);
	}

	public void addItem(T item) {

		items.add(item);
	}

	public boolean hasThreads() {

		return !threads.isEmpty();
	}

	public void run() throws InterruptedException, ExecutionException {

		initThreads();
		for (MyThread thread : threads) {
			thread.execute();
		}
		waitThreads();
	}

	private void initThreads() {

		for (MyThread thread : threads) {
			thread.setPool(this);
		}
	}

	public void waitThreads() throws InterruptedException, ExecutionException {

		try {
			for (MyThread thread : threads) {
				System.out.println(thread.get());
			}
		} catch (Throwable th) {
			th.printStackTrace();
		}
	}

	public List<MyThread> getThreads() {

		return threads;
	}

	public synchronized int getItemCount() {

		return items.size();
	}

	public synchronized T nextItem() {

		if (items.isEmpty())
			return null;
		return items.remove(0);
	}

	public void addListener(MyThreadPoolPane l) {

		listeners.add(l);
		for (MyThread th : threads)
			th.addPropertyChangeListener(l);
	}

	public void processed(Integer i) {

		for (MyThreadPoolPane l : listeners) {
			l.increaseProgressBy(1);
		}
	}

}
