package csl.tools.text;

import java.util.List;

public class EditDistance {

	public static int levenshtein(	List<? extends Object> s,
									List<? extends Object> t) {

		int m = s.size();
		int n = t.size();
		int[][] d = new int[m + 1][n + 1];

		for (int i = 0; i <= m; i++)
			d[i][0] = i;
		for (int i = 0; i <= n; i++)
			d[0][i] = i;

		int cost;
		for (int i = 0; i < m; i++) {
			for (int j = 0; j < n; j++) {
				if (s.get(i).equals(t.get(j)))
					cost = 0;
				else
					cost = 1;
				d[i + 1][j + 1] = Math.min(Math.min(d[i][j + 1] + 1, // deletion
						d[i + 1][j] + 1), // insertion
						d[i][j] + cost // substitution
				);
			}
		}
		return d[m][n];
	}

	public static int levenshtein(String s, String t) {

		int m = s.length();
		int n = t.length();
		int[][] d = new int[m + 1][n + 1];

		for (int i = 0; i <= m; i++)
			d[i][0] = i;
		for (int i = 0; i <= n; i++)
			d[0][i] = i;

		int cost;
		for (int i = 0; i < m; i++) {
			for (int j = 0; j < n; j++) {
				if (s.charAt(i) == t.charAt(j))
					cost = 0;
				else
					cost = 1;
				d[i + 1][j + 1] = Math.min(Math.min(d[i][j + 1] + 1, // deletion
						d[i + 1][j] + 1), // insertion
						d[i][j] + cost // substitution
				);
			}
		}
		return d[m][n];
	}

	public static void main(String[] args) {

		System.out.println(levenshtein("kitten", "sitting"));
		System.out.println(levenshtein("saturday", "sunday"));
	}
}
