package csl.tools.gui;


import java.awt.BorderLayout;
import java.awt.Color;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

/**
 * A panel with a single text path, intended as an application status bar. The
 * panel registers itself to {@link StatusMessageManager}.
 */
public class StatusBar extends JPanel{

    private JTextField textField;

    private Thread eraser;

    private int eraseDelay = 10000;

    public StatusBar() {
        textField = new JTextField(10);
        textField.setEditable(false);
        textField.setBorder(new EtchedBorder(EtchedBorder.RAISED));
        setLayout(new BorderLayout());
        add(textField, BorderLayout.CENTER);
    }

    /**
     * Gets the delay, in milliseconds, after which a displayed message is
     * deleted from the status bar. A value of <tt>0</tt> means no deletion.
     */
    public int getEraseDelay() {
        return eraseDelay;
    }

    /**
     * Sets the delay after which a displayed message is deleted from the status
     * bar. A value of <tt>0</tt> means no deletion.
     * 
     * @param milliseconds
     *            the delay, in milliseconds
     */
    public void setEraseDelay(int milliseconds) {
        eraseDelay = milliseconds;
    }

    public synchronized void newPermanentMessage(final String message) {
    	setEraseDelay(0);
    	newMessage(message);
    }
    
    /**
     * Displays a message in the status bar. If a positive delay has been
     * specified, the message is deleted from the status bar after this delay.
     * 
     * @param message
     *            the message to be displayed
     */
    public synchronized void newMessage(final String message) {
        if (eraser != null) {
            eraser.interrupt();
            eraser = null;
        }

        textField.setText(message);

        if (eraseDelay <= 0)
            return;

        eraser = new Thread() {
            @Override
            public void run() {
                if (StatusBar.this.eraser != this)
                    return;
                try {
                    sleep(eraseDelay);
                    if (StatusBar.this.eraser != this)
                        return;
                    textField.setText("");
                } catch (InterruptedException e) {
                }
            }
        };

        eraser.start();
    }

	public void changeColor(Color bg) {
		textField.setBackground(bg);
	}

}
