package csl.tools.algos;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ShuffleListEnumerator<E> {

	final private List<E> list;
	final private List<Integer> used;
	final private Random g;
	final private int size;

	public ShuffleListEnumerator(List<E> list) {

		super();
		this.list = list;
		this.size = list.size();
		this.used = new ArrayList<Integer>(this.size);
		this.g = new Random();
	}

	public ShuffleListEnumerator(List<E> list, int randomSeed) {

		super();
		this.list = list;
		this.size = list.size();
		this.used = new ArrayList<Integer>(this.size);
		this.g = new Random(randomSeed);
	}

	public E nextItem() {

		if (!isReady())
			throw new ArrayIndexOutOfBoundsException(size);
		int index = -1;
		do {
			index = g.nextInt(size);
		} while (used.contains(index));
		used.add(index);
		return list.get(index);
	}

	public boolean isReady() {

		return used.size() < size;
	}

	public static void main(String[] args) {

		List<String> list = new ArrayList<String>();
		list.add("un");
		list.add("deux");
		list.add("trois");
		list.add("quatre");
		list.add("cinq");
		list.add("six");
		list.add("sept");
		list.add("huit");
		list.add("neuf");
		list.add("dix");
		ShuffleListEnumerator<String> sh = new ShuffleListEnumerator<String>(
				list);
		while (sh.isReady()) {
			System.out.println(sh.nextItem());
		}
	}

	public void reset() {

		used.clear();
	}
}
