/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Annotation;
import core.Tag;
import core.TagConstraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.swing.DefaultListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformableItem
implements Serializable {
    protected static String[] syllables = new String[]{"ba", "bo", "bi", "la", "lo", "li", "ka", "ko", "ki", "za", "zo", "zu", "da", "do", "di", "fa", "fo", "fi"};
    protected static Random random = new Random(17L);
    protected String name;
    protected static int NB_VARIATIONS = 2000;
    protected List<Tag> tags = new ArrayList<Tag>();
    protected TransformableItem father;
    protected static float moreOrLessRatio = 0.1f;
    private int generationNumber = 0;

    public abstract String[] getFeatureNames();

    public abstract float getFeature(String var1);

    public abstract List<TransformableItem> createVariations(int var1);

    protected abstract void randomize();

    public TransformableItem() {
        this.name = this.getRandomName();
    }

    public abstract float distanceTo(TransformableItem var1);

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public static void setMoreOrLessRatio(int r) {
        moreOrLessRatio = (float)r / 100.0f;
    }

    private String getRandomName() {
        String res = String.valueOf(syllables[random.nextInt(syllables.length)]) + syllables[random.nextInt(syllables.length)] + syllables[random.nextInt(syllables.length)];
        return res;
    }

    public void setName(String n) {
        this.name = n;
    }

    public double classifyScalar(Tag t) {
        double d = t.classifyScalar(this);
        return d;
    }

    public double[] classifyScalar(List<Tag> tags) {
        double[] values = new double[tags.size()];
        int i = 0;
        while (i < tags.size()) {
            values[i] = this.classifyScalar(tags.get(i));
            ++i;
        }
        return values;
    }

    public double[] classifyScalar(DefaultListModel tagCts) {
        double[] values = new double[tagCts.size()];
        int i = 0;
        while (i < tagCts.size()) {
            TagConstraint tc = (TagConstraint)tagCts.elementAt(i);
            values[i] = tc.getConstraintType() == 3 ? -1.0 : this.classifyScalar(tc.getTag());
            ++i;
        }
        return values;
    }

    public void setFather(TransformableItem m) {
        this.father = m;
    }

    public TransformableItem getFather() {
        return this.father;
    }

    public String getTagList() {
        StringBuffer sb = new StringBuffer();
        for (Tag t : this.tags) {
            sb.append(String.valueOf(t.getName()) + " ");
        }
        return sb.toString();
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public String getFeaturesString() {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = this.getFeatureNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String f = stringArray[n];
            sb.append(String.valueOf(f) + ": " + this.getFeature(f) + "\n");
            ++n;
        }
        return sb.toString();
    }

    public float getFeatureAt(int i) {
        return this.getFeature(this.getFeatureNames()[i]);
    }

    public List<String> getFeatureNamesAndValues() {
        ArrayList<String> res = new ArrayList<String>();
        String[] stringArray = this.getFeatureNames();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String f = stringArray[n];
            res.add(String.valueOf(f) + ": " + this.getFeature(f) + "\n");
            ++n;
        }
        return res;
    }

    public static float[] computeAll(List<? extends TransformableItem> list, String f) {
        float[] res = new float[list.size()];
        int cpt = 0;
        for (TransformableItem transformableItem : list) {
            res[cpt] = transformableItem.getFeature(f);
            ++cpt;
        }
        return res;
    }

    public boolean hasTag(Tag tag) {
        for (Tag t : this.tags) {
            if (t != tag) continue;
            return true;
        }
        return false;
    }

    public int getNbFeatures() {
        return this.getFeatureNames().length;
    }

    public void clearTags() {
        this.tags.clear();
    }

    public int getNbTags() {
        return this.tags.size();
    }

    protected int maxAbs(List<Integer> l) {
        int max = 0;
        for (Integer i : l) {
            if (Math.abs(i) <= max) continue;
            max = Math.abs(i);
        }
        return max;
    }

    protected int randomInt(int max) {
        return random.nextInt(max + 1);
    }

    protected int randomIndex(List<Integer> ints) {
        if (ints.isEmpty()) {
            return -1;
        }
        return ints.get(random.nextInt(ints.size()));
    }

    protected float randomFloat(int min, int max) {
        return (float)min + random.nextFloat() * (float)(max - min + 1);
    }

    protected int randomInt(int min, int max) {
        return min + random.nextInt(max - min + 1);
    }

    private float randomFloatKeepVariance(float mean, float variance) {
        float ecartType = (float)Math.sqrt(variance);
        float a = (float)((double)mean - Math.sqrt(3.0) * (double)ecartType);
        float b = (float)((double)mean + Math.sqrt(3.0) * (double)ecartType);
        return a + random.nextFloat() * (b - a);
    }

    protected int max(List<Integer> pitches) {
        int max = 0;
        for (Integer i : pitches) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    protected int min(List<Integer> l) {
        int min = Integer.MAX_VALUE;
        for (Integer i : l) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    protected int minAbs(List<Integer> l) {
        int min = Integer.MAX_VALUE;
        for (Integer i : l) {
            if (Math.abs(i) >= min) continue;
            min = Math.abs(i);
        }
        return min;
    }

    protected float mean(List<Integer> l) {
        float sum = 0.0f;
        for (Integer i : l) {
            sum += (float)i.intValue();
        }
        return sum / (float)l.size();
    }

    protected static float mean(float[] list) {
        float sum = 0.0f;
        float[] fArray = list;
        int n = 0;
        int n2 = fArray.length;
        while (n < n2) {
            float f = fArray[n];
            sum += f;
            ++n;
        }
        return sum / (float)list.length;
    }

    protected float meanAbs(List<Integer> l) {
        float sum = 0.0f;
        for (Integer i : l) {
            sum += (float)Math.abs(i);
        }
        return sum / (float)l.size();
    }

    protected float variance(List<Integer> l) {
        float sum = 0.0f;
        float m = this.meanAbs(l);
        for (Integer i : l) {
            sum += ((float)i.intValue() - m) * ((float)i.intValue() - m);
        }
        return sum / (float)l.size();
    }

    protected static float variance(float[] list) {
        float sum = 0.0f;
        float m = TransformableItem.mean(list);
        float[] fArray = list;
        int n = 0;
        int n2 = fArray.length;
        while (n < n2) {
            float f = fArray[n];
            sum += (f - m) * (f - m);
            ++n;
        }
        return sum / (float)list.length;
    }

    protected float varianceAbs(List<Integer> l) {
        float sum = 0.0f;
        float m = this.meanAbs(l);
        for (Integer i : l) {
            sum += ((float)Math.abs(i) - m) * ((float)Math.abs(i) - m);
        }
        return sum / (float)l.size();
    }

    public TransformableItem findMoreOf(Annotation t, boolean moreOrLess) {
        double initialBestValue;
        if (t == null) {
            return null;
        }
        System.out.println("create variations...");
        List<TransformableItem> variations = this.createVariations(NB_VARIATIONS);
        System.out.println("done");
        System.out.println("sorting ...");
        this.sortByDistance(variations);
        System.out.println("done");
        double bestValue = initialBestValue = t.valueFor(this);
        System.out.println("look for : " + (moreOrLess ? " > " : " < ") + initialBestValue);
        TransformableItem bestItem = null;
        int trial = -1;
        System.out.println("starting value:" + initialBestValue);
        for (TransformableItem m : variations) {
            boolean foundBetter;
            this.showCurrentTrial(m, ++trial);
            double val = t.valueFor(m);
            if (moreOrLess) {
                if (val > bestValue) {
                    bestValue = val;
                    bestItem = m;
                }
            } else if (val < bestValue) {
                bestValue = val;
                bestItem = m;
            }
            this.showCurrentTrial(this, trial);
            boolean bl = foundBetter = moreOrLess && val > initialBestValue * (double)(1.0f + moreOrLessRatio) || !moreOrLess && val < initialBestValue * (double)Math.max(0.5f, 1.0f - moreOrLessRatio);
            if (!foundBetter) continue;
            bestItem = m;
            bestItem.setFather(this);
            this.setSonName(t, moreOrLess, bestItem);
            System.out.println("found after " + trial + " trials");
            return bestItem;
        }
        if (bestItem != null) {
            System.out.println("Found only slightly better ... ");
            bestItem.setFather(this);
            this.setSonName(t, moreOrLess, bestItem);
            System.out.println("found after " + trial + " trials");
            return bestItem;
        }
        System.out.println("did not find ANY better");
        return null;
    }

    protected void showCurrentTrial(TransformableItem m, int n) {
        System.out.println("(should be redefined) tries: " + m);
    }

    protected void setSonName(Annotation t, boolean moreOrLess, TransformableItem it) {
        String fatherName = this.getName();
        String suffix = "er ";
        if (!moreOrLess) {
            suffix = "less ";
        }
        if (fatherName.startsWith("much " + t.getName() + suffix)) {
            it.setName(fatherName);
        } else if (fatherName.startsWith(String.valueOf(t.getName()) + suffix)) {
            it.setName("much " + fatherName);
        } else {
            it.setName(String.valueOf(t.getName()) + suffix + fatherName);
        }
    }

    private void setBetterName(TransformableItem it) {
        String fatherName = this.getName();
        if (fatherName.startsWith("better")) {
            it.setName(fatherName);
            return;
        }
        it.setName("better " + fatherName);
    }

    public TransformableItem findConstrained(DefaultListModel tagCts) {
        boolean foundBetter;
        if (tagCts == null) {
            return null;
        }
        if (tagCts.size() == 0) {
            return null;
        }
        List<TransformableItem> variations = this.createVariations(NB_VARIATIONS);
        this.sortByDistance(variations);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        int i = 0;
        while (i < tagCts.size()) {
            tags.add(((TagConstraint)tagCts.elementAt(i)).getTag());
            ++i;
        }
        Double[] initialValues = new Double[tags.size()];
        int i2 = 0;
        while (i2 < tags.size()) {
            initialValues[i2] = new Double(((Tag)tags.get(i2)).classifyScalar(this));
            ++i2;
        }
        System.out.println("searching " + this.tagCtListShortString(tagCts) + " for " + this);
        TransformableItem bestItem = null;
        int trial = 0;
        for (TransformableItem m : variations) {
            ++trial;
            double[] values = m.classifyScalar(tagCts);
            if (!this.passTheTest(tagCts, initialValues, values)) continue;
            bestItem = m;
            System.out.println();
            System.out.println("found after " + trial + " iterations");
            bestItem.setFather(this);
            this.setBetterName(bestItem);
            return bestItem;
        }
        boolean bl = foundBetter = bestItem != null;
        if (foundBetter) {
            bestItem.setFather(this);
            this.setBetterName(bestItem);
            return bestItem;
        }
        if (bestItem == null) {
            System.out.println("did not find ANY better");
            return null;
        }
        return bestItem;
    }

    private String tagCtListShortString(DefaultListModel tagCts) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        boolean first = true;
        int i = 0;
        while (i < tagCts.size()) {
            TagConstraint tc = (TagConstraint)tagCts.elementAt(i);
            if (tc.isNotDontCare()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" and ");
                }
                sb.append(tc.toString());
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    private boolean passTheTest(DefaultListModel tagCts, Double[] initialValues, double[] values) {
        int i = 0;
        while (i < tagCts.size()) {
            if (!this.passTheTest((TagConstraint)tagCts.elementAt(i), initialValues[i], values[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean passTheTest(TagConstraint tc, double initialValue, double value) {
        int ct = tc.getConstraintType();
        switch (ct) {
            case 3: {
                break;
            }
            case 0: {
                return 2.0 * (Math.abs(value - initialValue) / Math.abs(value + initialValue)) <= (double)tc.getPercentage();
            }
            case 1: {
                return value >= initialValue * (double)(1.0f + tc.getPercentage());
            }
            case 2: {
                return value <= initialValue * (double)Math.max(0.5f, 1.0f - tc.getPercentage());
            }
        }
        return true;
    }

    public void removeTag(Tag t) {
        this.tags.remove(t);
    }

    public void addTag(Tag t) {
        if (!this.tags.contains(t)) {
            this.tags.add(t);
        }
    }

    public Tag tag(String s) {
        Tag t = this.createTag(this.stripQuotes(s.toLowerCase()));
        this.addTag(t);
        return t;
    }

    protected String stripQuotes(String s) {
        String res = s;
        if (s.startsWith("\"")) {
            res = s.substring(1);
        }
        if (s.startsWith(" ")) {
            res = s.substring(1);
        }
        if (res.endsWith("\"")) {
            res = res.substring(0, res.length() - 1);
        }
        if (res.endsWith(" ")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    protected Tag createTag(String s) {
        return Tag.named(s);
    }

    public void sortByDistance(List<TransformableItem> variations) {
        final TransformableItem start = this;
        Collections.sort(variations, new Comparator<TransformableItem>(){

            @Override
            public int compare(TransformableItem m1, TransformableItem m2) {
                float dif = m1.distanceTo(start) - m2.distanceTo(start);
                if (dif < 0.0f) {
                    return -1;
                }
                if (dif == 0.0f) {
                    return 0;
                }
                return 1;
            }
        });
    }

    public static void setNbVariations(Integer n) {
        NB_VARIATIONS = n;
    }

    public int getDepth() {
        if (this.father == null) {
            return 0;
        }
        return 1 + this.father.getDepth();
    }

    public abstract CharSequence CSVString(DefaultListModel var1);

    public abstract void initFromCSV(String[] var1);

    public double getTagValue(Tag t) {
        if (t == null) {
            return 0.0;
        }
        return this.classifyScalar(t);
    }

    public int getGenerationNumber() {
        return this.generationNumber;
    }

    public void setGenerationNumber(int generationNumber) {
        this.generationNumber = generationNumber;
    }

    public String toStringWithGeneration() {
        return String.valueOf(this.toString()) + " " + this.generationNumber;
    }
}

