package csl.tools.gui;

import java.awt.BorderLayout;
import java.util.List;
import java.util.Vector;

import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RecentItemMultiSelectionPanel<I> extends JPanel {

	private static final long			serialVersionUID	= 8820498112135835866L;
	private JScrollPane					jScrollPane			= null;
	private CheckBoxList				itemList			= null;
	private RecentItemListManager<I>	listManager;

	/**
	 * This is the default constructor
	 */
	public RecentItemMultiSelectionPanel() {

		super();
		initialize();
	}

	@SuppressWarnings("unchecked")
	public void setModel(RecentItemListManager<I> m) {

		listManager = m;
		DefaultListModel m2 = new DefaultListModel();
		for (int i = 0; i < m.getSize(); i++)
			m2
					.addElement(new JCheckBox(m.displayString((I) m
							.getElementAt(i))));
		getItemList().setModel(m2);
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		this.setLayout(new BorderLayout());
		this.setSize(300, 200);
		this.add(getJScrollPane(), java.awt.BorderLayout.CENTER);
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane() {

		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane.setViewportView(getItemList());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes itemList
	 * 
	 * @return javax.swing.JList
	 */
	private CheckBoxList getItemList() {

		if (itemList == null) {
			itemList = new CheckBoxList();
		}
		return itemList;
	}

	public List<I> getSelectedElements() {

		List<I> list = new Vector<I>();
		for (int i = 0; i < getItemList().getModel().getSize(); i++) {
			if (((JCheckBox) getItemList().getModel().getElementAt(i))
					.isSelected())
				list.add(elementAt(i));
		}
		return list;
	}

	@SuppressWarnings("unchecked")
	private I elementAt(int i) {

		return (I) listManager.getElementAt(i);
	}

}
