package csl.tools.files;

import java.io.File;
import java.io.IOException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class Xml extends Object {

	SAXParser	saxp;

	public Xml() {

		init();
	}

	public void init() {

		try {
			saxp = SAXParserFactory.newInstance().newSAXParser();
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		}
	}

	public void parse(File f) {

		DefaultHandler dh = new DefaultHandler() {

			private int	decal	= 0;

			@Override
			public void endDocument() throws SAXException {

				println("XML Parsing Completed");
				super.endDocument();
			}

			
			@Override
			public void error(SAXParseException e) throws SAXException {

				// TODO Auto-generated method stub
				super.error(e);
			}


			@Override
			public void fatalError(SAXParseException e) throws SAXException {

				// TODO Auto-generated method stub
				super.fatalError(e);
			}


			@Override
			public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {

				// TODO Auto-generated method stub
				super.ignorableWhitespace(ch, start, length);
			}

			@Override
			public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {

				// TODO Auto-generated method stub

				System.out.println("TOTO");
			
				return super.resolveEntity(publicId, systemId);
			}


			@Override
			public void setDocumentLocator(Locator locator) {

				// TODO Auto-generated method stub
				super.setDocumentLocator(locator);
			}


			@Override
			public void skippedEntity(String name) throws SAXException {

				// TODO Auto-generated method stub
				super.skippedEntity(name);
			}


			@Override
			public void startPrefixMapping(String prefix, String uri) throws SAXException {

				// TODO Auto-generated method stub
				super.startPrefixMapping(prefix, uri);
			}


			@Override
			public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {

				// TODO Auto-generated method stub
				super.unparsedEntityDecl(name, publicId, systemId, notationName);
			}


			@Override
			public void warning(SAXParseException e) throws SAXException {

				// TODO Auto-generated method stub
				super.warning(e);
			}


			@Override
			public void characters(char[] ch, int start, int length)
					throws SAXException {

				StringBuffer sb = new StringBuffer();
				for (int i = start; i < start + length; i++)
					sb.append(ch[i]);
				println(sb.toString());
			}

			@Override
			public void startElement(	String uri,
										String localName,
										String qName,
										Attributes attributes)
					throws SAXException {

				print("<" + qName + " ");
				println(attributes);
				System.out.println(">");
				decal++;
				super.startElement(uri, localName, qName, attributes);
			}

			@Override
			public void endElement(String uri, String localName, String qName)
					throws SAXException {

				decal--;
				println("</" + qName + ">");
				super.endElement(uri, localName, qName);
			}

			@Override
			public void startDocument() throws SAXException {

				println("Starting Parsing XML Document...");
				super.startDocument();
			}

			private void println(Attributes attributes) {

				for (int i = 0; i < attributes.getLength(); i++) {
					String n = attributes.getQName(i);
					String t = attributes.getType(i);
					String v = attributes.getValue(i);
					System.out.print("@" + n + " = \"" + v + "\"");
					if (i < attributes.getLength() - 1)
						System.out.print("; ");
				}
			}

			protected void print(String string) {

				String tabs = "";
				for (int i = 0; i < decal; i++)
					tabs += "\t";
				System.out.print(tabs + string);
			}

			protected void println(String string) {

				print(string);
				System.out.println();
			}
		};
		try {
			saxp.parse(f, dh);
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	public void load() {

		File f = FileTools.chooseFile("default.dir");
		parse(f);
	}

	public static void main(String[] args) {

		new Xml().load();
	}
}
