package csl.tools.csv;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

import csl.tools.files.FileTools;

public class CsvExplorer {

	final private File					rootDir;
	final private File					perfFile;
	final private List<String>			header;
	final private List<List<String>>	contents;
	private List<String>				columns;

	public CsvExplorer(File rootDir, File perfFile) throws IOException {

		super();
		this.rootDir = rootDir;
		this.perfFile = perfFile;
		List<String> lines = FileTools.readLines(perfFile);
		header = Arrays.asList(lines.get(0).split(","));
		lines.remove(0);
		contents = new ArrayList<List<String>>();
		for (String line : lines)
			contents.add(Arrays.asList(line.split(",")));
	}

	public CsvExplorer(String rootDir, String perfFile) throws IOException {

		this(new File(rootDir), new File(rootDir, perfFile));
	}

	private List<String> getColumns() {

		return header;
	}

	public String headerString() {

		StringBuffer hs = new StringBuffer();
		int i = 0;
		for (String s : getColumns()) {
			hs.append(i++).append(": ").append(s).append("\n");
		}
		return hs.toString();
	}

	public List<String> colString(int colIndex) {

		List<String> col = new ArrayList<String>(contents.size());
		for (int rowIndex = 0; rowIndex < contents.size(); rowIndex++)
			col.add(contents.get(rowIndex).get(colIndex));
		return col;
	}

	public List<Double> colDouble(int colIndex) {

		List<Double> col = new ArrayList<Double>(contents.size());
		for (int rowIndex = 0; rowIndex < contents.size(); rowIndex++)
			try {
				col.add(Double
						.parseDouble(contents.get(rowIndex).get(colIndex)));
			} catch (NumberFormatException e) {
				System.err.println("Col #" + colIndex
						+ " contains non double item");
				System.err.println("Item[" + rowIndex + "][" + colIndex + "]="
						+ contents.get(rowIndex).get(colIndex));
				return null;
			}
		return col;
	}

	public List<Integer> colInt(int colIndex) {

		List<Integer> col = new ArrayList<Integer>(contents.size());
		for (int rowIndex = 0; rowIndex < contents.size(); rowIndex++)
			try {
				col.add(Integer.parseInt(contents.get(rowIndex).get(colIndex)));
			} catch (NumberFormatException e) {
				System.err.println("Col #" + colIndex
						+ " contains non integer item");
				System.err.println("Item[" + rowIndex + "][" + colIndex + "]="
						+ contents.get(rowIndex).get(colIndex));
				return null;
			}
		return col;
	}

	public int indexOfColNamed(String colName) {

		return header.indexOf(colName);
	}

	public void removeRow(int i) {

		contents.remove(i);
	}

	public void removeRows(List<Integer> rowsToRemove) {

		Collections.sort(rowsToRemove);
		Collections.reverse(rowsToRemove);
		for (int i : rowsToRemove)
			removeRow(i);
	}

	@Override
	public String toString() {

		StringBuffer sb = new StringBuffer();
		for (String col : header) {
			sb.append(col + ",");
		}
		sb.append("\n");
		for (List<String> row : contents) {
			for (String cell : row) {
				sb.append(cell + ",");
			}
			sb.append("\n");
		}
		return sb.toString();
	}

	public static void main(String[] args) throws IOException {

		ColFilter filterGT5 = new ColFilter() {

			@Override
			public boolean acceptInteger(Integer cell) {

				return cell > 25;
			}

			@Override
			public boolean acceptDouble(Double cell) {

				// TODO Auto-generated method stub
				return false;
			}

			@Override
			public boolean acceptString(String cell) {

				// TODO Auto-generated method stub
				return false;
			}
		};
		ColFilter filterLT5 = new ColFilter() {

			@Override
			public boolean acceptInteger(Integer cell) {

				return cell <= 25;
			}

			@Override
			public boolean acceptDouble(Double cell) {

				// TODO Auto-generated method stub
				return false;
			}

			@Override
			public boolean acceptString(String cell) {

				// TODO Auto-generated method stub
				return false;
			}
		};

		CsvExplorer comp = new CsvExplorer(
				"D:\\Users\\roy\\sony\\StreamMan\\Experimental Data",
				"Compared Perf of Exp1, 8 and Corr.csv");
		filterLT5.applyToInteger(comp, "Exp-1 Ac Results");
		filterGT5.applyToInteger(comp, "Exp-1 Corr Results All");
		filterGT5.applyToInteger(comp, "Exp-8 Ac Results");
//		for(String s: comp.colString(0)) {
//			System.out.println(s);
//		}
		System.out.println(comp);
	}
}
