/*
 * Decompiled with CFR 0.152.
 */
package thd;

import core.FFVItem;
import core.Tag;
import core.TransformableItem;
import core.text.TextualTag;
import csl.tools.files.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import thd.Neighbor;
import thd.ThdMovieFragment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThdEngine {
    private static final ThdEngine soleInstance = new ThdEngine();
    private Random random = new Random(7L);

    public static ThdEngine getEngine() {
        return soleInstance;
    }

    private ThdEngine() {
        if (soleInstance != null) {
            System.err.println("singleton class, use ThdEngine.getEngine()");
        }
    }

    public List<TransformableItem> getAllMovieFragments() {
        return ThdMovieFragment.getAllMovieFragments();
    }

    public List<Tag> getAllTags() {
        return Tag.getAllTags();
    }

    private ThdMovieFragment movieAt(int i) {
        return ThdMovieFragment.movieFragmentAt(i);
    }

    public ThdMovieFragment createMovieFragment(String ref) {
        ThdMovieFragment mf = this.movieFragmentNamed(ref);
        if (mf == null) {
            mf = new ThdMovieFragment();
            mf.setName(ref);
        }
        return mf;
    }

    public List<ThdMovieFragment> createMovieFragments(String ... refs) {
        ArrayList<ThdMovieFragment> res = new ArrayList<ThdMovieFragment>(refs.length);
        String[] stringArray = refs;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String ref = stringArray[n];
            ThdMovieFragment mf = this.movieFragmentNamed(ref);
            if (mf == null) {
                mf = new ThdMovieFragment();
                mf.setName(ref);
            }
            res.add(mf);
            ++n;
        }
        return res;
    }

    public void addTag(String tagName, String movieSegmentRef) {
        ThdMovieFragment mf = this.movieFragmentNamed(movieSegmentRef);
        if (mf == null) {
            System.err.println("this moviefragment does not exist: " + movieSegmentRef);
        }
        mf.tag(tagName);
    }

    public void addTags(String[] tags, String ref) {
        ThdMovieFragment mf = this.movieFragmentNamed(ref);
        if (mf == null) {
            System.err.println("this moviefragment does not exist: " + ref);
        }
        String[] stringArray = tags;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            mf.tag(t);
            ++n;
        }
    }

    public Tag tagNamed(String tagName) {
        return TextualTag.named(tagName);
    }

    public ThdMovieFragment movieFragmentNamed(String movieSegmentRef) {
        for (TransformableItem mf : ThdMovieFragment.getAllMovieFragments()) {
            if (!mf.getName().equals(movieSegmentRef)) continue;
            return (ThdMovieFragment)mf;
        }
        return null;
    }

    public void removeTag(String tagName, String movieSegmentRef) {
        Tag t = this.tagNamed(tagName);
        ThdMovieFragment mf = this.movieFragmentNamed(movieSegmentRef);
        mf.removeTag(t);
    }

    public void clearTags(String movieSegmentRef) {
        ThdMovieFragment mf = this.movieFragmentNamed(movieSegmentRef);
        mf.clearTags();
    }

    public void reTrain() {
        System.out.println("retrain all tags ...");
        Tag.clearAllClassifiersAndTrainingSets();
        int i = 0;
        while (i < Tag.getAllTagSize()) {
            this.learnTag(Tag.tagAt(i));
            ++i;
        }
        System.out.println(" ...done");
    }

    public void reTrain(String tagName) {
        Tag t = this.tagNamed(tagName);
        t.clearClassifierAndTrainingSet();
        this.learnTag(t);
    }

    public Neighbor findMore(String movieSegmentRef, String tagName, float percent, boolean moreOrLess) {
        ThdMovieFragment movie = this.movieFragmentNamed(movieSegmentRef);
        Tag t = this.tagNamed(tagName);
        if (movie == null || t == null) {
            System.out.println("Incorrect tag or movie fragment reference");
            return null;
        }
        FFVItem.computeMeansAndVariances(ThdMovieFragment.getAllMovieFragments());
        Neighbor n = movie.findNeighborMoreOf(t, percent, moreOrLess);
        return n;
    }

    public List<Neighbor> findSomeMore(String movieSegmentRef, String tagName, float percent, boolean moreOrLess, int nb) {
        return null;
    }

    protected void learnTag(Tag tag) {
        ThdMovieFragment m;
        int i = 0;
        while (i < ThdMovieFragment.allMovieFragmentSize()) {
            m = this.movieAt(i);
            if (m.hasTag(tag)) {
                tag.addPositiveExample(m);
            }
            ++i;
        }
        if (tag.getNegativeTag() != null) {
            i = 0;
            while (i < ThdMovieFragment.allMovieFragmentSize()) {
                m = this.movieAt(i);
                if (m.hasTag(tag.getNegativeTag())) {
                    tag.addNegativeExample(m);
                }
                if (tag.getNbNegativeExamples() > tag.getNbPositiveExamples()) break;
                ++i;
            }
        }
        if (tag.getPositiveExamples().size() == 0) {
            System.out.println("probleme, no positive example for " + tag + "!");
            return;
        }
        if (ThdMovieFragment.allMovieFragmentSize() <= tag.getNbPositiveExamples()) {
            System.out.println("probleme, no negative example for " + tag + "!");
            return;
        }
        int cpt = 0;
        while (cpt++ < 5000 && tag.getNbNegativeExamples() < tag.getNbPositiveExamples()) {
            int ind = this.random.nextInt(ThdMovieFragment.allMovieFragmentSize());
            ThdMovieFragment randomItem = this.movieAt(ind);
            if (randomItem.hasTag(tag) || randomItem.getNbTags() <= 0 || !tag.acceptAsNegativeExample(randomItem) || tag.hasAsExample(randomItem)) continue;
            tag.addNegativeExample(randomItem);
        }
        tag.train();
    }

    public void loadFromTextFile(File f) {
        try {
            List lines = FileTools.readLines((File)f);
            lines.remove(0);
            for (String line : lines) {
                ThdMovieFragment m = new ThdMovieFragment();
                String[] tokens = line.split("\t");
                m.initFromCSV(tokens);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("probleme");
        }
    }

    public void showAllTagValues() {
        for (Tag t : this.getAllTags()) {
            for (TransformableItem mf : this.getAllMovieFragments()) {
                System.out.println(t + " value for: " + mf + " = " + t.valueFor(mf));
            }
        }
    }

    public void showAllTextValues() {
        for (TransformableItem mf : this.getAllMovieFragments()) {
            System.out.println(((ThdMovieFragment)mf).getText());
        }
    }

    public void clearAll() {
        ThdMovieFragment.clear();
        Tag.clear();
    }
}

