/*
 * Decompiled with CFR 0.152.
 */
package movies;

import core.Annotation;
import core.Tag;
import core.TransformableItem;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import movies.AutoTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Movie
extends TransformableItem {
    private static final long serialVersionUID = 2259360332156631817L;
    private static List<TransformableItem> allMovies = new ArrayList<TransformableItem>(400);

    public Movie() {
        allMovies.add(this);
    }

    @Override
    public CharSequence CSVString(DefaultListModel items) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.name) + "\t");
        if (this.father == null) {
            sb.append("-1\t");
        } else {
            sb.append(items.indexOf(this.father) + "\t");
        }
        for (Tag t : this.getTags()) {
            sb.append(String.valueOf(t.getName()) + ",");
        }
        sb.append("\t");
        return sb.toString();
    }

    @Override
    public List<TransformableItem> createVariations(int n) {
        return allMovies;
    }

    @Override
    public float getFeature(String f) {
        return 0.0f;
    }

    @Override
    public String[] getFeatureNames() {
        String[] res = new String[]{};
        return res;
    }

    @Override
    public void initFromCSV(String[] feats) {
        String[] newTags;
        this.name = this.stripQuotes(feats[0]);
        if (feats.length < 3) {
            return;
        }
        String[] stringArray = newTags = feats[2].split(",");
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String t = stringArray[n];
            this.tag(this.stripQuotes(t));
            ++n;
        }
    }

    @Override
    protected void randomize() {
    }

    @Override
    protected Tag createTag(String s) {
        return AutoTag.named(s);
    }

    @Override
    protected void setSonName(Annotation t, boolean moreOrLess, TransformableItem it) {
        if (moreOrLess) {
            it.setName(String.valueOf(it.getName()) + " (plus " + t.getName() + ")");
        } else {
            it.setName(String.valueOf(it.getName()) + " (moins " + t.getName() + ")");
        }
    }

    @Override
    public float distanceTo(TransformableItem m) {
        List<Tag> mTags = m.getTags();
        int commonTagNb = 0;
        for (Tag t : this.getTags()) {
            if (!mTags.contains(t)) continue;
            ++commonTagNb;
        }
        float sim = 2.0f * (float)commonTagNb / (float)(mTags.size() + this.getTags().size());
        return 1.0f - sim;
    }
}

