/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.ForeignKeyDeleteAction;
import com.sleepycat.je.ForeignKeyNullifier;
import com.sleepycat.je.ForeignMultiKeyNullifier;
import com.sleepycat.je.SecondaryKeyCreator;
import com.sleepycat.je.SecondaryMultiKeyCreator;
import com.sleepycat.je.utilint.DatabaseUtil;

public class SecondaryConfig
extends DatabaseConfig {
    public static final SecondaryConfig DEFAULT = new SecondaryConfig();
    private boolean allowPopulate;
    private SecondaryKeyCreator keyCreator;
    private SecondaryMultiKeyCreator multiKeyCreator;
    private Database foreignKeyDatabase;
    private ForeignKeyDeleteAction foreignKeyDeleteAction = ForeignKeyDeleteAction.ABORT;
    private ForeignKeyNullifier foreignKeyNullifier;
    private ForeignMultiKeyNullifier foreignMultiKeyNullifier;
    private boolean immutableSecondaryKey;

    public SecondaryConfig setKeyCreator(SecondaryKeyCreator keyCreator) {
        this.keyCreator = keyCreator;
        return this;
    }

    public SecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public SecondaryConfig setMultiKeyCreator(SecondaryMultiKeyCreator multiKeyCreator) {
        this.multiKeyCreator = multiKeyCreator;
        return this;
    }

    public SecondaryMultiKeyCreator getMultiKeyCreator() {
        return this.multiKeyCreator;
    }

    public SecondaryConfig setAllowPopulate(boolean allowPopulate) {
        this.allowPopulate = allowPopulate;
        return this;
    }

    public boolean getAllowPopulate() {
        return this.allowPopulate;
    }

    public SecondaryConfig setForeignKeyDatabase(Database foreignKeyDatabase) {
        this.foreignKeyDatabase = foreignKeyDatabase;
        return this;
    }

    public Database getForeignKeyDatabase() {
        return this.foreignKeyDatabase;
    }

    public SecondaryConfig setForeignKeyDeleteAction(ForeignKeyDeleteAction foreignKeyDeleteAction) {
        DatabaseUtil.checkForNullParam((Object)foreignKeyDeleteAction, "foreignKeyDeleteAction");
        this.foreignKeyDeleteAction = foreignKeyDeleteAction;
        return this;
    }

    public ForeignKeyDeleteAction getForeignKeyDeleteAction() {
        return this.foreignKeyDeleteAction;
    }

    public SecondaryConfig setForeignKeyNullifier(ForeignKeyNullifier foreignKeyNullifier) {
        this.foreignKeyNullifier = foreignKeyNullifier;
        return this;
    }

    public ForeignKeyNullifier getForeignKeyNullifier() {
        return this.foreignKeyNullifier;
    }

    public SecondaryConfig setForeignMultiKeyNullifier(ForeignMultiKeyNullifier foreignMultiKeyNullifier) {
        this.foreignMultiKeyNullifier = foreignMultiKeyNullifier;
        return this;
    }

    public ForeignMultiKeyNullifier getForeignMultiKeyNullifier() {
        return this.foreignMultiKeyNullifier;
    }

    public SecondaryConfig setImmutableSecondaryKey(boolean immutableSecondaryKey) {
        this.immutableSecondaryKey = immutableSecondaryKey;
        return this;
    }

    public boolean getImmutableSecondaryKey() {
        return this.immutableSecondaryKey;
    }

    public SecondaryConfig clone() {
        return (SecondaryConfig)super.clone();
    }

    void validate(DatabaseConfig configArg) throws DatabaseException {
        boolean imskMatch;
        super.validate(configArg);
        if (configArg == null || !(configArg instanceof SecondaryConfig)) {
            throw new IllegalArgumentException("The SecondaryConfig argument is null.");
        }
        SecondaryConfig config = (SecondaryConfig)configArg;
        boolean kcMatch = this.equalOrBothNull(config.getKeyCreator(), this.keyCreator);
        boolean mkcMatch = this.equalOrBothNull(config.getMultiKeyCreator(), this.multiKeyCreator);
        boolean fkdMatch = config.getForeignKeyDatabase() == this.foreignKeyDatabase;
        boolean fkdaMatch = config.getForeignKeyDeleteAction() == this.foreignKeyDeleteAction;
        boolean fknMatch = this.equalOrBothNull(config.getForeignKeyNullifier(), this.foreignKeyNullifier);
        boolean fmknMatch = this.equalOrBothNull(config.getForeignMultiKeyNullifier(), this.foreignMultiKeyNullifier);
        boolean bl = imskMatch = config.getImmutableSecondaryKey() == this.immutableSecondaryKey;
        if (kcMatch && mkcMatch && fkdMatch && fkdaMatch && fknMatch && fmknMatch && imskMatch) {
            return;
        }
        String message = this.genSecondaryConfigMismatchMessage(config, kcMatch, mkcMatch, fkdMatch, fkdaMatch, fknMatch, fmknMatch, imskMatch);
        throw new IllegalArgumentException(message);
    }

    private boolean equalOrBothNull(Object o1, Object o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    String genSecondaryConfigMismatchMessage(DatabaseConfig config, boolean kcMatch, boolean mkcMatch, boolean fkdMatch, boolean fkdaMatch, boolean fknMatch, boolean fmknMatch, boolean imskMatch) {
        StringBuffer ret = new StringBuffer("The following SecondaryConfig parameters for the\ncached Database do not match the parameters for the\nrequested Database:\n");
        if (!kcMatch) {
            ret.append(" SecondaryKeyCreator\n");
        }
        if (!mkcMatch) {
            ret.append(" SecondaryMultiKeyCreator\n");
        }
        if (!fkdMatch) {
            ret.append(" ForeignKeyDelete\n");
        }
        if (!fkdaMatch) {
            ret.append(" ForeignKeyDeleteAction\n");
        }
        if (!fknMatch) {
            ret.append(" ForeignKeyNullifier\n");
        }
        if (!fknMatch) {
            ret.append(" ForeignMultiKeyNullifier\n");
        }
        if (!imskMatch) {
            ret.append(" ImmutableSecondaryKey\n");
        }
        return ret.toString();
    }

    public String toString() {
        return "keyCreator=" + this.keyCreator + "\nmultiKeyCreator=" + this.multiKeyCreator + "\nallowPopulate=" + this.allowPopulate + "\nforeignKeyDatabase=" + this.foreignKeyDatabase + "\nforeignKeyDeleteAction=" + (Object)((Object)this.foreignKeyDeleteAction) + "\nforeignKeyNullifier=" + this.foreignKeyNullifier + "\nforeignMultiKeyNullifier=" + this.foreignMultiKeyNullifier + "\nimmutableSecondaryKey=" + this.immutableSecondaryKey + "\n";
    }
}

