/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.JoinConfig;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoredCollection<E>
extends StoredContainer
implements Collection<E> {
    public static final int DEFAULT_ITERATOR_BLOCK_SIZE = 10;
    private int iteratorBlockSize = 10;

    StoredCollection(DataView view) {
        super(view);
    }

    public int getIteratorBlockSize() {
        return this.iteratorBlockSize;
    }

    public void setIteratorBlockSize(int blockSize) {
        if (blockSize < 2) {
            throw new IllegalArgumentException("blockSize is less than two: " + blockSize);
        }
        this.iteratorBlockSize = blockSize;
    }

    final boolean add(Object key, Object value) {
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.putNoDupData(key, value, null, false);
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    BlockIterator blockIterator() {
        return new BlockIterator(this, this.isWriteAllowed(), this.iteratorBlockSize);
    }

    @Override
    public Iterator<E> iterator() {
        return this.blockIterator();
    }

    public StoredIterator<E> storedIterator() {
        return this.storedIterator(this.isWriteAllowed());
    }

    public StoredIterator<E> storedIterator(boolean writeAllowed) {
        try {
            return new StoredIterator(this, writeAllowed && this.isWriteAllowed(), null);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    public StoredIterator<E> iterator(boolean writeAllowed) {
        return this.storedIterator(writeAllowed);
    }

    @Override
    public Object[] toArray() {
        ArrayList<E> list = new ArrayList<E>();
        StoredIterator<E> i = null;
        try {
            try {
                i = this.storedIterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
                Object var5_3 = null;
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            StoredIterator.close(i);
            throw throwable;
        }
        StoredIterator.close(i);
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int j = 0;
        StoredIterator<E> i = null;
        try {
            block7: {
                try {
                    i = this.storedIterator();
                    while (j < a.length && i.hasNext()) {
                        a[j++] = i.next();
                    }
                    if (j < a.length) {
                        a[j] = null;
                        break block7;
                    }
                    if (!i.hasNext()) break block7;
                    ArrayList<T> list = new ArrayList<T>(Arrays.asList(a));
                    while (i.hasNext()) {
                        list.add(i.next());
                    }
                    a = list.toArray(a);
                }
                catch (Exception e) {
                    throw StoredContainer.convertException(e);
                }
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            StoredIterator.close(i);
            throw throwable;
        }
        StoredIterator.close(i);
        return a;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsAll(Collection<?> coll) {
        boolean bl;
        Iterator i;
        block7: {
            boolean bl2;
            block6: {
                i = null;
                try {
                    try {
                        i = this.storedOrExternalIterator(coll);
                        while (i.hasNext()) {
                            if (this.contains(i.next())) continue;
                            bl2 = false;
                            Object var5_6 = null;
                            break block6;
                        }
                        bl = true;
                        break block7;
                    }
                    catch (Exception e) {
                        throw StoredContainer.convertException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    StoredIterator.close(i);
                    throw throwable;
                }
            }
            StoredIterator.close(i);
            return bl2;
        }
        Object var5_7 = null;
        StoredIterator.close(i);
        return bl;
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            i = this.storedOrExternalIterator(coll);
            boolean changed = false;
            while (i.hasNext()) {
                if (!this.add(i.next())) continue;
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean changed = false;
            i = this.storedOrExternalIterator(coll);
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        StoredIterator<E> i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            boolean changed = false;
            i = this.storedIterator();
            while (i.hasNext()) {
                if (coll.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return changed;
        }
        catch (Exception e) {
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Collection) {
            boolean bl;
            Collection otherColl = StoredCollection.copyCollection(other);
            StoredIterator<E> i = null;
            try {
                i = this.storedIterator();
                boolean otherHasAll = true;
                while (i.hasNext()) {
                    if (otherColl.remove(i.next())) continue;
                    otherHasAll = false;
                    break;
                }
                bl = otherHasAll && otherColl.isEmpty();
                Object var7_7 = null;
            }
            catch (Exception e) {
                try {
                    throw StoredContainer.convertException(e);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    StoredIterator.close(i);
                    throw throwable;
                }
            }
            StoredIterator.close(i);
            return bl;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public List<E> toList() {
        ArrayList<E> arrayList;
        ArrayList<E> list = new ArrayList<E>();
        StoredIterator<E> i = null;
        try {
            i = this.storedIterator();
            while (i.hasNext()) {
                list.add(i.next());
            }
            arrayList = list;
            Object var5_5 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                StoredIterator.close(i);
                throw throwable;
            }
        }
        StoredIterator.close(i);
        return arrayList;
    }

    public String toString() {
        String string;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        StoredIterator<E> i = null;
        try {
            i = this.storedIterator();
            while (i.hasNext()) {
                if (buf.length() > 1) {
                    buf.append(',');
                }
                buf.append(i.next().toString());
            }
            buf.append(']');
            string = buf.toString();
            Object var5_5 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                StoredIterator.close(i);
                throw throwable;
            }
        }
        StoredIterator.close(i);
        return string;
    }

    @Override
    public int size() {
        boolean countDups = this.iterateDuplicates();
        if (countDups && !this.view.range.hasBound()) {
            try {
                return (int)DbCompat.getDatabaseCount(this.view.db);
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
        int count = 0;
        CursorConfig cursorConfig = this.view.currentTxn.isLockingMode() ? CursorConfig.READ_UNCOMMITTED : null;
        DataCursor cursor = null;
        try {
            try {
                cursor = new DataCursor(this.view, false, cursorConfig);
                OperationStatus status = cursor.getFirst(false);
                while (status == OperationStatus.SUCCESS) {
                    count = countDups ? (count += cursor.count()) : ++count;
                    status = cursor.getNextNoDup(false);
                }
                Object var7_8 = null;
            }
            catch (Exception e) {
                throw StoredContainer.convertException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.closeCursor(cursor);
            throw throwable;
        }
        this.closeCursor(cursor);
        return count;
    }

    public StoredIterator<E> join(StoredContainer[] indices, Object[] indexKeys, JoinConfig joinConfig) {
        try {
            DataView[] indexViews = new DataView[indices.length];
            for (int i = 0; i < indices.length; ++i) {
                indexViews[i] = indices[i].view;
            }
            DataCursor cursor = this.view.join(indexViews, indexKeys, joinConfig);
            return new StoredIterator(this, false, cursor);
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    final E getFirstOrLast(boolean doGetFirst) {
        E e;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = doGetFirst ? cursor.getFirst(false) : cursor.getLast(false);
            e = status == OperationStatus.SUCCESS ? (E)this.makeIteratorData(null, cursor) : null;
            Object var6_6 = null;
        }
        catch (Exception e2) {
            try {
                throw StoredContainer.convertException(e2);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return e;
    }

    E makeIteratorData(BaseIterator iterator, DataCursor cursor) {
        return this.makeIteratorData(iterator, cursor.getKeyThang(), cursor.getPrimaryKeyThang(), cursor.getValueThang());
    }

    abstract E makeIteratorData(BaseIterator var1, DatabaseEntry var2, DatabaseEntry var3, DatabaseEntry var4);

    abstract boolean hasValues();

    boolean iterateDuplicates() {
        return true;
    }

    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("Duplicates required");
        }
    }

    int getIndexOffset() {
        return 0;
    }

    private static Collection copyCollection(Object other) {
        if (other instanceof StoredCollection) {
            return ((StoredCollection)other).toList();
        }
        return new ArrayList((Collection)other);
    }
}

