/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallTreeConstructor;

public class MiddleOutConstructor
extends BallTreeConstructor
implements Randomizable,
TechnicalInformationHandler {
    private static final long serialVersionUID = -8523314263062524462L;
    protected int m_RSeed = 1;
    protected Random rand = new Random(this.m_RSeed);
    protected boolean m_RandomInitialAnchor = true;

    public String globalInfo() {
        return "The class that builds a BallTree middle out.\n\nFor more information see also:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Andrew W. Moore");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "The Anchors Hierarchy: Using the Triangle Inequality to Survive High Dimensional Data");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2000");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "UAI '00: Proceedings of the 16th Conference on Uncertainty in Artificial Intelligence");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "397-405");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann Publishers Inc.");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "San Francisco, CA, USA");
        TechnicalInformation technicalInformation2 = technicalInformation.add(TechnicalInformation.Type.MASTERSTHESIS);
        technicalInformation2.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        technicalInformation2.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        technicalInformation2.setValue(TechnicalInformation.Field.YEAR, "2007");
        technicalInformation2.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        technicalInformation2.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return technicalInformation;
    }

    public BallNode buildTree() throws Exception {
        this.m_NumLeaves = 0;
        this.m_MaxDepth = 0;
        this.m_NumNodes = 0;
        BallNode ballNode = this.buildTreeMiddleOut(0, this.m_Instances.numInstances() - 1);
        return ballNode;
    }

    protected BallNode buildTreeMiddleOut(int n, int n2) throws Exception {
        int n3 = n2 - n + 1;
        if (n3 <= this.m_MaxInstancesInLeaf) {
            Instance instance = BallNode.calcCentroidPivot(n, n2, this.m_InstList, this.m_Instances);
            BallNode ballNode = new BallNode(n, n2, this.m_NumNodes, instance, BallNode.calcRadius(n, n2, this.m_InstList, this.m_Instances, instance, this.m_DistanceFunction));
            return ballNode;
        }
        int n4 = (int)Math.round(Math.sqrt(n3));
        if (n4 <= 1) {
            Instance instance = BallNode.calcCentroidPivot(n, n2, this.m_InstList, this.m_Instances);
            BallNode ballNode = new BallNode(n, n2, this.m_NumNodes, instance, BallNode.calcRadius(n, n2, this.m_InstList, this.m_Instances, instance, this.m_DistanceFunction));
            return ballNode;
        }
        Vector vector = new Vector(n4);
        this.createAnchorsHierarchy(vector, n4, n, n2);
        BallNode ballNode = this.mergeNodes(vector, n, n2);
        this.buildLeavesMiddleOut(ballNode);
        return ballNode;
    }

    protected void createAnchorsHierarchy(Vector vector, int n, int n2, int n3) throws Exception {
        TempNode tempNode;
        TempNode tempNode2 = tempNode = this.m_RandomInitialAnchor ? this.getRandomAnchor(n2, n3) : this.getFurthestFromMeanAnchor(n2, n3);
        Vector vector2 = new Vector(n - 1);
        vector.add(tempNode);
        while (vector.size() < n) {
            Instance instance;
            TempNode tempNode3 = new TempNode();
            tempNode3.points = new MyIdxList();
            tempNode3.anchor = instance = this.m_Instances.instance(tempNode2.points.getFirst().idx);
            tempNode3.idx = tempNode2.points.getFirst().idx;
            this.setInterAnchorDistances(vector, tempNode3, vector2);
            this.stealPoints(tempNode3, vector, vector2);
            tempNode3.radius = tempNode3.points.getFirst().distance;
            vector.add(tempNode3);
            tempNode2 = (TempNode)vector.elementAt(0);
            for (int i = 1; i < vector.size(); ++i) {
                tempNode3 = (TempNode)vector.elementAt(i);
                if (!(tempNode3.radius > tempNode2.radius)) continue;
                tempNode2 = tempNode3;
            }
        }
    }

    protected void buildLeavesMiddleOut(BallNode ballNode) throws Exception {
        if (ballNode.m_Left != null && ballNode.m_Right != null) {
            this.buildLeavesMiddleOut(ballNode.m_Left);
            this.buildLeavesMiddleOut(ballNode.m_Right);
        } else {
            if (ballNode.m_Left != null || ballNode.m_Right != null) {
                throw new Exception("Invalid leaf assignment. Please check code");
            }
            BallNode ballNode2 = this.buildTreeMiddleOut(ballNode.m_Start, ballNode.m_End);
            if (ballNode2.m_Left != null && ballNode2.m_Right != null) {
                ballNode.m_Left = ballNode2.m_Left;
                ballNode.m_Right = ballNode2.m_Right;
                this.buildLeavesMiddleOut(ballNode);
            } else if (ballNode2.m_Left != null || ballNode2.m_Right != null) {
                throw new Exception("Invalid leaf assignment. Please check code");
            }
        }
    }

    protected BallNode mergeNodes(Vector vector, int n, int n2) throws Exception {
        for (int i = 0; i < vector.size(); ++i) {
            TempNode tempNode = (TempNode)vector.get(i);
            tempNode.anchor = this.calcPivot(tempNode.points, new MyIdxList(), this.m_Instances);
            tempNode.radius = this.calcRadius(tempNode.points, new MyIdxList(), tempNode.anchor, this.m_Instances);
        }
        Instance instance = null;
        int n3 = -1;
        int n4 = -1;
        while (vector.size() > 1) {
            double d = Double.POSITIVE_INFINITY;
            for (int i = 0; i < vector.size(); ++i) {
                TempNode tempNode = (TempNode)vector.get(i);
                for (int j = i + 1; j < vector.size(); ++j) {
                    TempNode tempNode2 = (TempNode)vector.get(j);
                    Instance instance2 = this.calcPivot(tempNode, tempNode2, this.m_Instances);
                    double d2 = this.calcRadius(tempNode, tempNode2);
                    if (!(d2 < d)) continue;
                    d = d2;
                    instance = instance2;
                    n3 = i;
                    n4 = j;
                }
            }
            TempNode tempNode = new TempNode();
            tempNode.left = (TempNode)vector.get(n3);
            tempNode.right = (TempNode)vector.get(n4);
            tempNode.anchor = instance;
            tempNode.radius = this.calcRadius(tempNode.left.points, tempNode.right.points, instance, this.m_Instances);
            tempNode.points = tempNode.left.points.append(tempNode.left.points, tempNode.right.points);
            vector.remove(n3);
            vector.remove(n4 - 1);
            vector.add(tempNode);
        }
        TempNode tempNode = (TempNode)vector.get(vector.size() - 1);
        if (n2 - n + 1 != tempNode.points.length()) {
            throw new Exception("Root nodes instance list is of irregular length. Please check code. Length should be: " + (n2 - n + 1) + " whereas it is found to be: " + tempNode.points.length());
        }
        for (int i = 0; i < tempNode.points.length(); ++i) {
            this.m_InstList[n + i] = tempNode.points.get((int)i).idx;
        }
        BallNode ballNode = this.makeBallTreeNodes(tempNode, n, n2, 0);
        return ballNode;
    }

    protected BallNode makeBallTreeNodes(TempNode tempNode, int n, int n2, int n3) {
        BallNode ballNode = null;
        if (tempNode.left != null && tempNode.right != null) {
            ballNode = new BallNode(n, n2, this.m_NumNodes, tempNode.anchor, tempNode.radius);
            ++this.m_NumNodes;
            ballNode.m_Left = this.makeBallTreeNodes(tempNode.left, n, n + tempNode.left.points.length() - 1, n3 + 1);
            ballNode.m_Right = this.makeBallTreeNodes(tempNode.right, n + tempNode.left.points.length(), n2, n3 + 1);
            ++this.m_MaxDepth;
        } else {
            ballNode = new BallNode(n, n2, this.m_NumNodes, tempNode.anchor, tempNode.radius);
            ++this.m_NumNodes;
            ++this.m_NumLeaves;
        }
        return ballNode;
    }

    protected TempNode getFurthestFromMeanAnchor(int n, int n2) {
        TempNode tempNode = new TempNode();
        Instance instance = BallNode.calcCentroidPivot(n, n2, this.m_InstList, this.m_Instances);
        tempNode.radius = Double.NEGATIVE_INFINITY;
        for (int i = n; i <= n2; ++i) {
            Instance instance2 = this.m_Instances.instance(this.m_InstList[i]);
            double d = this.m_DistanceFunction.distance(instance, instance2);
            if (!(d > tempNode.radius)) continue;
            tempNode.idx = this.m_InstList[i];
            tempNode.anchor = instance2;
            tempNode.radius = d;
        }
        this.setPoints(tempNode, n, n2, this.m_InstList);
        return tempNode;
    }

    protected TempNode getRandomAnchor(int n, int n2) {
        TempNode tempNode = new TempNode();
        tempNode.idx = this.m_InstList[n + this.rand.nextInt(n2 - n + 1)];
        tempNode.anchor = this.m_Instances.instance(tempNode.idx);
        this.setPoints(tempNode, n, n2, this.m_InstList);
        tempNode.radius = tempNode.points.getFirst().distance;
        return tempNode;
    }

    public void setPoints(TempNode tempNode, int n, int n2, int[] nArray) {
        tempNode.points = new MyIdxList();
        for (int i = n; i <= n2; ++i) {
            Instance instance = this.m_Instances.instance(nArray[i]);
            double d = this.m_DistanceFunction.distance(tempNode.anchor, instance);
            tempNode.points.insertReverseSorted(nArray[i], d);
        }
    }

    public void setInterAnchorDistances(Vector vector, TempNode tempNode, Vector vector2) throws Exception {
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            Instance instance = ((TempNode)vector.elementAt((int)i)).anchor;
            dArray[i] = this.m_DistanceFunction.distance(instance, tempNode.anchor);
        }
        vector2.add(dArray);
    }

    public void stealPoints(TempNode tempNode, Vector vector, Vector vector2) {
        int n;
        int n2 = -1;
        double d = Double.NEGATIVE_INFINITY;
        double[] dArray = (double[])vector2.lastElement();
        for (n = 0; n < dArray.length; ++n) {
            if (!(d < dArray[n])) continue;
            d = dArray[n];
            n2 = n;
        }
        n = 0;
        Instance instance = tempNode.anchor;
        for (int i = 0; i < vector.size(); ++i) {
            TempNode tempNode2 = (TempNode)vector.elementAt(i);
            Instance instance2 = tempNode2.anchor;
            n = 0;
            double d2 = this.m_DistanceFunction.distance(instance, instance2) / 2.0;
            for (int j = 0; j < tempNode2.points.length(); ++j) {
                double d3;
                ListNode listNode = tempNode2.points.get(j);
                if (listNode.distance < d2) break;
                double d4 = this.m_DistanceFunction.distance(instance, this.m_Instances.instance(listNode.idx));
                if (!(d4 < (d3 = listNode.distance))) continue;
                tempNode.points.insertReverseSorted(listNode.idx, d4);
                tempNode2.points.remove(j);
                n = 1;
            }
            if (n == 0) continue;
            tempNode2.radius = tempNode2.points.getFirst().distance;
        }
    }

    public Instance calcPivot(TempNode tempNode, TempNode tempNode2, Instances instances) {
        int n;
        int n2 = this.m_Instances.classIndex();
        double[] dArray = new double[instances.numAttributes()];
        double d = (double)tempNode.points.length() / (double)(tempNode.points.length() + tempNode2.points.length());
        double d2 = (double)tempNode2.points.length() / (double)(tempNode.points.length() + tempNode2.points.length());
        for (n = 0; n < tempNode.anchor.numValues(); ++n) {
            if (tempNode.anchor.index(n) == n2) continue;
            int n3 = n;
            dArray[n3] = dArray[n3] + tempNode.anchor.valueSparse(n) * d;
        }
        for (n = 0; n < tempNode2.anchor.numValues(); ++n) {
            if (tempNode2.anchor.index(n) == n2) continue;
            int n4 = n;
            dArray[n4] = dArray[n4] + tempNode2.anchor.valueSparse(n) * d2;
        }
        Instance instance = new Instance(1.0, dArray);
        return instance;
    }

    public Instance calcPivot(MyIdxList myIdxList, MyIdxList myIdxList2, Instances instances) {
        int n;
        Instance instance;
        int n2;
        int n3 = this.m_Instances.classIndex();
        double[] dArray = new double[instances.numAttributes()];
        for (n2 = 0; n2 < myIdxList.length(); ++n2) {
            instance = instances.instance(myIdxList.get((int)n2).idx);
            for (n = 0; n < instance.numValues(); ++n) {
                if (instance.index(n) == n3) continue;
                int n4 = n;
                dArray[n4] = dArray[n4] + instance.valueSparse(n);
            }
        }
        for (n2 = 0; n2 < myIdxList2.length(); ++n2) {
            instance = instances.instance(myIdxList2.get((int)n2).idx);
            for (n = 0; n < instance.numValues(); ++n) {
                if (instance.index(n) == n3) continue;
                int n5 = n;
                dArray[n5] = dArray[n5] + instance.valueSparse(n);
            }
        }
        n2 = 0;
        n = myIdxList.length() + myIdxList2.length();
        while (n2 < dArray.length) {
            int n6 = n2++;
            dArray[n6] = dArray[n6] / (double)n;
        }
        instance = new Instance(1.0, dArray);
        return instance;
    }

    public double calcRadius(TempNode tempNode, TempNode tempNode2) {
        Instance instance = tempNode.anchor;
        Instance instance2 = tempNode2.anchor;
        double d = tempNode.radius + this.m_DistanceFunction.distance(instance, instance2) + tempNode2.radius;
        return d / 2.0;
    }

    public double calcRadius(MyIdxList myIdxList, MyIdxList myIdxList2, Instance instance, Instances instances) {
        double d;
        int n;
        double d2 = Double.NEGATIVE_INFINITY;
        for (n = 0; n < myIdxList.length(); ++n) {
            d = this.m_DistanceFunction.distance(instance, instances.instance(myIdxList.get((int)n).idx));
            if (!(d > d2)) continue;
            d2 = d;
        }
        for (n = 0; n < myIdxList2.length(); ++n) {
            d = this.m_DistanceFunction.distance(instance, instances.instance(myIdxList2.get((int)n).idx));
            if (!(d > d2)) continue;
            d2 = d;
        }
        return d2;
    }

    public int[] addInstance(BallNode ballNode, Instance instance) throws Exception {
        throw new Exception("Addition of instances after the tree is built, not possible with MiddleOutConstructor.");
    }

    public void setMaxInstancesInLeaf(int n) throws Exception {
        if (n < 2) {
            throw new Exception("The maximum number of instances in a leaf for using MiddleOutConstructor must be >=2.");
        }
        super.setMaxInstancesInLeaf(n);
    }

    public String initialAnchorRandomTipText() {
        return "Whether the initial anchor is chosen randomly.";
    }

    public boolean isInitialAnchorRandom() {
        return this.m_RandomInitialAnchor;
    }

    public void setInitialAnchorRandom(boolean bl) {
        this.m_RandomInitialAnchor = bl;
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public int getSeed() {
        return this.m_RSeed;
    }

    public void setSeed(int n) {
        this.m_RSeed = n;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tThe seed for the random number generator used\n\tin selecting random anchor.\n(default: 1)", "S", 1, "-S <num>"));
        vector.addElement(new Option("\tUse randomly chosen initial anchors.", "R", 0, "-R"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('S', stringArray);
        if (string.length() > 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(1);
        }
        this.setInitialAnchorRandom(Utils.getFlag('R', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-S");
        vector.add("" + this.getSeed());
        if (this.isInitialAnchorRandom()) {
            vector.add("-R");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void checkIndicesList(MyIdxList myIdxList, int n, int n2) throws Exception {
        for (int i = 0; i < myIdxList.size(); ++i) {
            ListNode listNode = (ListNode)myIdxList.elementAt(i);
            boolean bl = false;
            for (int j = n; j <= n2; ++j) {
                if (listNode.idx != this.m_InstList[j]) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            throw new Exception("Error: Element " + listNode.idx + " of the list not in " + "the array." + "\nArray: " + this.printInsts(n, n2) + "\nList: " + this.printList(myIdxList));
        }
    }

    public String printInsts(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("i: ");
            for (int i = n; i <= n2; ++i) {
                if (i == n) {
                    stringBuffer.append("" + this.m_InstList[i]);
                    continue;
                }
                stringBuffer.append(", " + this.m_InstList[i]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public String printList(MyIdxList myIdxList) {
        if (myIdxList == null || myIdxList.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            for (int i = 0; i < myIdxList.size(); ++i) {
                ListNode listNode = (ListNode)myIdxList.elementAt(i);
                if (i == 0) {
                    stringBuffer.append("" + listNode.idx);
                    continue;
                }
                stringBuffer.append(", " + listNode.idx);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    protected class MyIdxList
    extends FastVector {
        private static final long serialVersionUID = -2283869109722934927L;

        public MyIdxList() {
        }

        public MyIdxList(int n) {
            super(n);
        }

        public ListNode getFirst() {
            return (ListNode)this.elementAt(0);
        }

        public void insertReverseSorted(int n, double d) {
            Enumeration enumeration = this.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                ListNode listNode = (ListNode)enumeration.nextElement();
                if (listNode.distance < d) break;
                ++n2;
            }
            this.insertElementAt(new ListNode(n, d), n2);
        }

        public ListNode get(int n) {
            return (ListNode)this.elementAt(n);
        }

        public void remove(int n) {
            this.removeElementAt(n);
        }

        public int length() {
            return super.size();
        }

        public MyIdxList append(MyIdxList myIdxList, MyIdxList myIdxList2) {
            MyIdxList myIdxList3 = new MyIdxList(myIdxList.size() + myIdxList2.size());
            myIdxList3.appendElements(myIdxList);
            myIdxList3.appendElements(myIdxList2);
            return myIdxList3;
        }

        public void checkSorting(MyIdxList myIdxList) throws Exception {
            Enumeration enumeration = myIdxList.elements();
            ListNode listNode = null;
            ListNode listNode2 = null;
            while (enumeration.hasMoreElements()) {
                if (listNode == null) {
                    listNode = (ListNode)enumeration.nextElement();
                    continue;
                }
                listNode2 = (ListNode)enumeration.nextElement();
                if (!(listNode.distance < listNode2.distance)) continue;
                throw new Exception("List not sorted correctly. first.distance: " + listNode.distance + " second.distance: " + listNode2.distance + " Please check code.");
            }
        }
    }

    protected class ListNode {
        int idx = -1;
        double distance = Double.NEGATIVE_INFINITY;

        public ListNode(int n, double d) {
            this.idx = n;
            this.distance = d;
        }
    }

    protected class TempNode {
        Instance anchor;
        int idx;
        double radius;
        MyIdxList points;
        TempNode left;
        TempNode right;

        protected TempNode() {
        }

        public String toString() {
            if (this.points == null || this.points.length() == 0) {
                return this.idx + "";
            }
            StringBuffer stringBuffer = new StringBuffer();
            try {
                stringBuffer.append(this.idx + " p: ");
                for (int i = 0; i < this.points.size(); ++i) {
                    ListNode listNode = (ListNode)this.points.elementAt(i);
                    if (i == 0) {
                        stringBuffer.append("" + listNode.idx);
                        continue;
                    }
                    stringBuffer.append(", " + listNode.idx);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return stringBuffer.toString();
        }
    }
}

