package csl.tools.threads;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;

public abstract class ThreadPool<V, T extends OneThread<V>> implements
		PropertyChangeListener {

	private List<T>	threads	= new Vector<T>();
	private List<V>	items;
	private int		count;
	private int		itemCount;
	private boolean	done	= false;

	public void process(List<V> items) {

		count = 0;
		this.items = items;
		itemCount = items.size();
		for (T th : threads)
			th.execute();
	}

	public boolean hasMoreItems() {

		return !items.isEmpty();
	}

	public V nextItem() {

		return items.remove(0);
	}

	public final void oneDone(T th, V e) {

		count++;
		show(th, e);
		if (count == itemCount)
			done();
	}

	private void done() {

		done = true;
	}

	public boolean isDone() {

		return done;
	}

	protected abstract void show(T th, V e);

	public void addThread(T thread) {

		threads.add(thread);
	}

	public void propertyChange(PropertyChangeEvent evt) {

		System.out.println(evt.getPropertyName() + "\t" + evt.getSource()
				+ "\t" + evt.getOldValue() + "\t" + evt.getNewValue());
	}
}
