package csl.tools.threads;

import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import javax.swing.JLabel;

public class TestThreadPane extends JPanel {

	private static final long	serialVersionUID		= -1271236137415621721L;
	private JTextField			threadCountTextField	= null;
	private JTextField			itemCountTextField		= null;
	private JButton				runButton				= null;
	private JProgressBar		progressBar				= null;
	private JLabel				threadCountLabel		= null;
	private JLabel				itemCountLabel			= null;

	/**
	 * This is the default constructor
	 */
	public TestThreadPane() {

		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
		gridBagConstraints21.gridx = 0;
		gridBagConstraints21.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints21.gridy = 1;
		itemCountLabel = new JLabel();
		itemCountLabel.setText("Item Count");
		GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
		gridBagConstraints11.gridx = 0;
		gridBagConstraints11.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints11.gridy = 0;
		threadCountLabel = new JLabel();
		threadCountLabel.setText("Thread Count");
		GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
		gridBagConstraints3.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints3.gridy = 3;
		gridBagConstraints3.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints3.gridwidth = 3;
		gridBagConstraints3.gridx = 0;
		GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
		gridBagConstraints2.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints2.gridy = 2;
		gridBagConstraints2.gridx = 2;
		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = java.awt.GridBagConstraints.NONE;
		gridBagConstraints1.gridx = 2;
		gridBagConstraints1.gridy = 1;
		gridBagConstraints1.weightx = 0.0;
		gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.NONE;
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.weightx = 0.0;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		this.setLayout(new GridBagLayout());
		this.setSize(176, 131);
		this.add(getThreadCountTextField(), gridBagConstraints);
		this.add(getItemCountTextField(), gridBagConstraints1);
		this.add(getRunButton(), gridBagConstraints2);
		this.add(getProgressBar(), gridBagConstraints3);
		this.add(threadCountLabel, gridBagConstraints11);
		this.add(itemCountLabel, gridBagConstraints21);
	}

	/**
	 * This method initializes threadCountTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getThreadCountTextField() {

		if (threadCountTextField == null) {
			threadCountTextField = new JTextField();
			threadCountTextField
					.setPreferredSize(new java.awt.Dimension(60, 20));
			threadCountTextField.setText("4");
		}
		return threadCountTextField;
	}

	/**
	 * This method initializes itemCountTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getItemCountTextField() {

		if (itemCountTextField == null) {
			itemCountTextField = new JTextField();
			itemCountTextField.setPreferredSize(new java.awt.Dimension(60, 20));
			itemCountTextField.setText("100");
		}
		return itemCountTextField;
	}

	/**
	 * This method initializes runButton
	 * 
	 * @return javax.swing.JButton
	 */
	private JButton getRunButton() {

		if (runButton == null) {
			runButton = new JButton();
			runButton.setText("run");
			runButton.addActionListener(new java.awt.event.ActionListener() {

				public void actionPerformed(java.awt.event.ActionEvent e) {

					TestThreadPool ttp = new TestThreadPool();
					ttp.run(getThreadCount(), getItemCount());
				}
			});
		}
		return runButton;
	}

	protected int getThreadCount() {

		return Integer.parseInt(getThreadCountTextField().getText());
	}

	protected int getItemCount() {

		return Integer.parseInt(getItemCountTextField().getText());
	}

	/**
	 * This method initializes progressBar
	 * 
	 * @return javax.swing.JProgressBar
	 */
	private JProgressBar getProgressBar() {

		if (progressBar == null) {
			progressBar = new JProgressBar();
		}
		return progressBar;
	}

} // @jve:decl-index=0:visual-constraint="10,10"
