/*
 * Created on Apr 20, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package csl.tools.files;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;

import javax.xml.transform.TransformerException;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMParseException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * @author roy
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class XmlJdomTools {

    /**
     * Static method used to save any XML document to a file
     * 
     * @param d
     *            Is the XML <code>Document</code> to be saved
     * @param xmlFile
     *            Is the destination <code>File</code> When the XML cannot be
     *            parsed successfully
     * @throws IOException
     */
    public static void saveXMLDocument(Document d, File xmlFile)
            throws IOException {
        xmlFile.getParentFile().mkdirs();
        FileWriter fw = new FileWriter(xmlFile);
        FileOutputStream fow = new FileOutputStream(xmlFile);
        OutputStreamWriter osw = new OutputStreamWriter(fow, "ISO-8859-1");
        Format f = Format.getPrettyFormat();
        f.setEncoding("ISO-8859-1");
        XMLOutputter xo = new XMLOutputter(f);
        xo.output(d, osw);
        fw.close();
    }

    public static void saveXMLDocument(Element e, File xmlFile)
            throws IOException {
        saveXMLDocument(new Document(e), xmlFile);
    }

    /**
     * Read the XML <code>File</code> in parameter, and build an XML
     * <code>Node</code> representing its contents. Return the resulting
     * <code>Node</code>.
     * 
     * @param xmlFile
     * @return
     * @throws IOException
     * @throws JDOMException
     * @throws TransformerException
     */
    public static Element loadFromXML(File xmlFile) throws JDOMException,
            IOException {
        SAXBuilder builder = new SAXBuilder();
        try {
            Document document = builder.build(xmlFile);
            return document.getRootElement();
        } catch (JDOMParseException ex) {
            /**
             * Comes probably from a character set issue
             */
            System.err
                    .println("Could not parse XML, probably because of wrong character set");
        }
        return null;
    }

    /**
     * Print the XML <code>Document</code> in parameter on the standard output
     * stream
     * 
     * @param d
     *            is the document to print out
     * @throws IOException
     */
    public static void printXML(Document d) throws IOException {
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        xo.output(d, System.out);
    }

    /**
     * Print the XML contents of <code>File xmlFile</code> on the standard
     * output stream
     * 
     * @param xmlFile
     * @throws JDOMException
     * @throws IOException
     */
    public static void printXML(File xmlFile) throws IOException, JDOMException {
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        xo.output(loadFromXML(xmlFile), System.out);
    }

    /**
     * Print the XML contents of <code>File xmlFile</code> on a given output
     * stream
     * 
     * @param xmlFile
     *            is the file whose content is to be printed
     * @param printStream
     *            is the targeted output stream
     * @throws JDOMException
     * @throws IOException
     * @throws TransformerException
     */
    public static void printXML(File xmlFile, PrintStream printStream)
            throws IOException, JDOMException {
        XMLOutputter xo = new XMLOutputter(Format.getPrettyFormat());
        xo.output(loadFromXML(xmlFile), printStream);
    }

    /**
     * Create and return a new XML <code>Document</code>
     * 
     * @return
     */
    public static Document newDocument() {
        return new Document();
    }

}
