package csl.tools.files;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DirCompare {

	final File			dir1, dir2;
	boolean				rec		= true;
	static FileFilter	fileFF;
	static FileFilter	dirFF	= FileTools.folderFF();
	static {
		fileFF = new FileFilter() {

			public boolean accept(File pathname) {

				return pathname.isFile();
			}
		};
	}

	public DirCompare(File d1, File d2) {

		super();
		this.dir1 = d1;
		this.dir2 = d2;
	}

	public DirCompare(String d1, String d2) {

		this(new File(d1), new File(d2));
	}

	public void setRec(boolean rec) {

		this.rec = rec;
	}

	public boolean getRec() {

		return rec;
	}

	public HashMap<File, DirComparison> compare() {

		HashMap<File, DirComparison> m = new HashMap<File, DirComparison>();
		m.put(dir1, basicCompare(dir1, dir2));
		List<File> subDirs1 = new ArrayList<File>();
		List<File> subDirs2 = new ArrayList<File>();
		for (File dir : dir1.listFiles(dirFF)) {
			subDirs1.add(dir);
		}
		for (File dir : dir2.listFiles(dirFF)) {
			subDirs2.add(dir);
		}
		for (File dir1 : subDirs1) {
			File dir2 = find(dir1, subDirs2);
			m.put(dir1, basicCompare(dir1, dir2));
		}
		return m;
	}

	/**
	 * files is supposed to be sorted
	 * 
	 * @param f1
	 * @param files
	 * @return
	 */
	private File find(File f1, File[] files) {

		for (File f2 : files) {
			if (f2.getName().equalsIgnoreCase(f1.getName()))
				return f2;
		}
		return null;
	}

	private File find(File f1, List<File> files) {

		for (File f2 : files) {
			if (f2.getName().equalsIgnoreCase(f1.getName()))
				return f2;
		}
		return null;
	}

	/**
	 * This is a one-way comparison, from d1's point of view
	 * 
	 * @param d1
	 * @param d2
	 * @return
	 */
	public DirComparison basicCompare(File d1, File d2) {

		if (d2 == null) {
			return new DirComparison(d1, null, Arrays.asList(dir1
					.listFiles(fileFF)), new ArrayList<File>(),
					new ArrayList<File>());
		}
		File[] d1Files = d1.listFiles(fileFF);
		File[] d2Files = d2.listFiles(fileFF);
		Arrays.sort(d1Files);
		Arrays.sort(d2Files);
		List<File> newer = new ArrayList<File>();
		List<File> older = new ArrayList<File>();
		List<File> same = new ArrayList<File>();
		for (File f1 : d1Files) {
			File f2 = find(f1, d2Files);
			long f1LastModified = f1.lastModified();
			if (f2 == null)
				newer.add(f1);
			else {
				long f2LastModified = f2.lastModified();
				if (f1LastModified > f2LastModified)
					newer.add(f1);
				else if (f1.lastModified() < f2LastModified)
					older.add(f1);
				else
					same.add(f1);
			}
		}
		return new DirComparison(d1, d2, newer, older, same);
	}

	public static void main(String[] args) {

		HashMap<File, DirComparison> compare = new DirCompare("c:/tmp",
				"c:/tmpCopy").compare();
		System.out.println(compare);
	}
}
