/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import java.util.Hashtable;
import libsvm.svm_problem;

public class ConfMatrix {
    int m_numc = 0;
    Hashtable m_lables = null;
    int m_size = 0;
    int[][] m_conMatrix;
    double[] m_classes;

    public ConfMatrix(svm_problem prob) {
        this.m_size = prob.l;
        double[] m_clazz = new double[this.m_size];
        int i = 0;
        while (i < this.m_size) {
            double current_lable = prob.y[i];
            boolean found = false;
            int j = 0;
            while (j < this.m_numc) {
                if (current_lable == m_clazz[j]) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                m_clazz[this.m_numc++] = current_lable;
            }
            ++i;
        }
        this.m_classes = new double[this.m_numc];
        this.m_conMatrix = new int[this.m_numc][];
        int j = 0;
        while (j < this.m_numc) {
            this.m_conMatrix[j] = new int[this.m_numc];
            this.m_classes[j] = m_clazz[j];
            ++j;
        }
        i = 0;
        while (i < this.m_numc) {
            int j2 = 0;
            while (j2 < this.m_numc) {
                this.m_conMatrix[i][j2] = 0;
                ++j2;
            }
            ++i;
        }
        this.m_lables = new Hashtable(this.m_numc);
        j = 0;
        while (j < this.m_numc) {
            this.m_lables.put(new Double(m_clazz[j]), new Integer(j));
            ++j;
        }
    }

    public void add(double[] y, double[] target) {
        int len = y.length;
        int i = 0;
        while (i < len) {
            int row = (Integer)this.m_lables.get(new Double(y[i]));
            int col = (Integer)this.m_lables.get(new Double(target[i]));
            int[] nArray = this.m_conMatrix[row];
            int n = col;
            nArray[n] = nArray[n] + 1;
            ++i;
        }
    }

    public void report() {
        int i = 0;
        while (i < this.m_numc) {
            System.out.print("   " + this.m_classes[i]);
            ++i;
        }
        System.out.print("\n");
        i = 0;
        while (i < this.m_numc) {
            int j = 0;
            while (j < this.m_numc) {
                System.out.print("  " + this.m_conMatrix[i][j]);
                ++j;
            }
            System.out.print("\n");
            ++i;
        }
    }

    public static void main(String[] args) {
    }
}

