/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Instance;
import weka.core.Instances;

public class NormalizedPolyKernel
extends PolyKernel {
    static final long serialVersionUID = 1248574185532130851L;

    public NormalizedPolyKernel() {
        this.setExponent(2.0);
    }

    public NormalizedPolyKernel(Instances instances, int n, double d, boolean bl) throws Exception {
        super(instances, n, d, bl);
    }

    public String globalInfo() {
        return "The normalized polynomial kernel.\nK(x,y) = <x,y>/sqrt(<x,x><y,y>) where <x,y> = PolyKernel(x,y)";
    }

    public double eval(int n, int n2, Instance instance) throws Exception {
        double d = Math.sqrt(super.eval(n, n, instance) * (this.m_keys != null ? super.eval(n2, n2, this.m_data.instance(n2)) : super.eval(-1, -1, this.m_data.instance(n2))));
        if (d != 0.0) {
            return super.eval(n, n2, instance) / d;
        }
        return 0.0;
    }

    public void setExponent(double d) {
        if (d != 1.0) {
            super.setExponent(d);
        } else {
            System.out.println("A linear kernel, i.e., Exponent=1, is not possible!");
        }
    }

    public String toString() {
        String string = this.getUseLowerOrder() ? "Normalized Poly Kernel with lower order: K(x,y) = (<x,y>+1)^" + this.getExponent() + "/" + "((<x,x>+1)^" + this.getExponent() + "*" + "(<y,y>+1)^" + this.getExponent() + ")^(1/2)" : "Normalized Poly Kernel: K(x,y) = <x,y>^" + this.getExponent() + "/" + "(<x,x>^" + this.getExponent() + "*" + "<y,y>^" + this.getExponent() + ")^(1/2)";
        return string;
    }
}

