/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;

public class BuddyLocker
extends BasicLocker {
    private final Locker buddy;

    protected BuddyLocker(EnvironmentImpl env, Locker buddy) {
        super(env);
        this.buddy = buddy;
        buddy.addBuddy(this);
    }

    public static BuddyLocker createBuddyLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        BasicLocker ret = null;
        try {
            ret = new BuddyLocker(env, buddy);
        }
        catch (DatabaseException DE) {
            ret.operationEnd(false);
            throw DE;
        }
        return ret;
    }

    void close() {
        super.close();
        this.buddy.removeBuddy(this);
    }

    Locker getBuddy() {
        return this.buddy;
    }

    public Txn getTxnLocker() {
        return this.buddy.getTxnLocker();
    }

    public void releaseNonTxnLocks() throws DatabaseException {
        super.releaseNonTxnLocks();
        this.buddy.releaseNonTxnLocks();
    }

    public boolean sharesLocksWith(Locker other) {
        if (super.sharesLocksWith(other)) {
            return true;
        }
        return this.buddy == other;
    }

    public long getLockTimeout() {
        return this.buddy.getLockTimeout();
    }

    public long getTxnTimeout() {
        return this.buddy.getTxnTimeout();
    }

    public void setLockTimeout(long timeout) {
        this.buddy.setLockTimeout(timeout);
    }

    public void setTxnTimeout(long timeout) {
        this.buddy.setTxnTimeout(timeout);
    }

    public boolean isTimedOut() {
        return this.buddy.isTimedOut();
    }

    public void setOnlyAbortable(OperationFailureException cause) {
        this.buddy.setOnlyAbortable(cause);
    }

    void checkPreempted(Locker allowPreemptedLocker) throws OperationFailureException {
        this.buddy.checkPreempted(allowPreemptedLocker);
    }

    public boolean isReplicationDefined() {
        return this.buddy.isReplicationDefined();
    }
}

