/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.LocalCBVLSNUpdater;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.stream.FeederReplicaHandshake;
import com.sleepycat.je.rep.stream.FeederReplicaSyncup;
import com.sleepycat.je.rep.stream.FeederSource;
import com.sleepycat.je.rep.stream.MasterFeederSource;
import com.sleepycat.je.rep.stream.MasterStatus;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Feeder {
    private int heartbeatInterval;
    private final FeederManager feederManager;
    private final RepNode repNode;
    private final RepImpl repImpl;
    private final NamedChannel feederReplicaChannel;
    private final InputThread inputThread;
    private final OutputThread outputThread;
    private final FeederSource feederSource;
    private int protocolVersion;
    private VLSN feederVLSN;
    private volatile long lastResponseTime = 0L;
    private final MasterStatus masterStatus;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final Logger logger;
    private final NameIdPair nameIdPair;
    private NameIdPair replicaNameIdPair = NameIdPair.NULL;
    private static int TRANSFER_LOGGING_THRESHOLD_MS = 1000;
    private static long sprayAfterNMessagesCount = 0L;

    SocketChannel configureChannel(SocketChannel channel) throws IOException {
        try {
            channel.configureBlocking(true);
            LoggerUtils.info(this.logger, this.repImpl, "Feeder accepted connection from " + channel);
            long readTimeout = (long)this.repNode.getConfigManager().getInt(RepParams.FEEDER_HEARTBEAT_TIMEOUT) * (long)this.repNode.getHeartbeatInterval();
            channel.socket().setSoTimeout(readTimeout > Integer.MAX_VALUE ? 0 : (int)readTimeout);
            channel.socket().setTcpNoDelay(true);
            return channel;
        }
        catch (IOException e) {
            LoggerUtils.warning(this.logger, this.repImpl, "IO exception while configuring channel Exception:" + e.getMessage());
            throw e;
        }
    }

    Feeder(FeederManager feederManager, SocketChannel feederReplicaChannel) throws DatabaseException, IOException {
        this.feederManager = feederManager;
        this.repNode = feederManager.repNode();
        this.repImpl = this.repNode.getRepImpl();
        this.masterStatus = this.repNode.getMasterStatus();
        this.nameIdPair = this.repNode.getNameIdPair();
        this.feederSource = new MasterFeederSource(this.repNode.getRepImpl(), this.repNode.getVLSNIndex(), this.nameIdPair);
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.feederReplicaChannel = new NamedChannel(this.configureChannel(feederReplicaChannel));
        this.inputThread = new InputThread(this.repNode.getRepImpl());
        this.outputThread = new OutputThread(this.repNode.getRepImpl());
        this.heartbeatInterval = feederManager.repNode().getHeartbeatInterval();
    }

    void startFeederThreads() {
        this.inputThread.start();
    }

    public Feeder() {
        this.feederManager = null;
        this.repNode = null;
        this.repImpl = null;
        this.masterStatus = null;
        this.feederSource = null;
        this.feederReplicaChannel = null;
        this.nameIdPair = NameIdPair.NULL;
        this.logger = LoggerUtils.getLoggerFixedPrefix(this.getClass(), "TestFeeder");
        this.inputThread = null;
        this.outputThread = null;
        this.shutdown.set(true);
    }

    public StatGroup getProtocolStats(StatsConfig config) {
        Protocol protocol = this.outputThread.protocol;
        return protocol != null ? protocol.getStats(config) : new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
    }

    void resetStats() {
        Protocol protocol = this.outputThread.protocol;
        if (protocol != null) {
            protocol.resetStats();
        }
    }

    public SocketChannel getFeederReplicaChannel() {
        return this.feederReplicaChannel.getChannel();
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    public NameIdPair getReplicaNameIdPair() {
        return this.replicaNameIdPair;
    }

    void shutdown(Exception shutdownException) {
        StatGroup pstats;
        boolean changed = this.shutdown.compareAndSet(false, true);
        if (!changed) {
            return;
        }
        this.feederManager.removeFeeder(this);
        StatGroup statGroup = pstats = this.inputThread.protocol != null ? this.inputThread.protocol.getStats(StatsConfig.DEFAULT) : new StatGroup("BinaryProtocol", "Network traffic due to the replication stream.");
        if (this.outputThread.protocol != null) {
            pstats.addAll(this.outputThread.protocol.getStats(StatsConfig.DEFAULT));
        }
        this.feederManager.incStats(pstats);
        LoggerUtils.info(this.logger, this.repImpl, "Shutting down feeder for replica " + this.replicaNameIdPair.getName() + (shutdownException == null ? "" : " Reason: " + shutdownException.getMessage()) + RepUtils.writeTimesString(pstats));
        if (this.repNode.getReplicaCloseCatchupMs() >= 0L) {
            try {
                this.inputThread.join();
            }
            catch (InterruptedException e) {
                LoggerUtils.warning(this.logger, this.repImpl, "Interrupted while waiting to join thread:" + this.outputThread);
            }
        }
        this.outputThread.shutdownThread(this.logger);
        this.inputThread.shutdownThread(this.logger);
        LoggerUtils.finest(this.logger, this.repImpl, this.feederReplicaChannel + " isOpen=" + this.feederReplicaChannel.getChannel().isOpen());
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    public static void setSprayAfterNMessagesCount(long sANMC) {
        sprayAfterNMessagesCount = sANMC;
    }

    public String dumpState() {
        return "feederVLSN=" + this.feederVLSN;
    }

    public static class ExitException
    extends Exception {
        public ExitException(String message) {
            super(message);
        }

        public ExitException(Throwable cause) {
            super(cause);
        }
    }

    private class IOThreadsHandler
    implements Thread.UncaughtExceptionHandler {
        private IOThreadsHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            LoggerUtils.severe(Feeder.this.logger, Feeder.this.repImpl, "Uncaught exception in feeder thread " + t + e.getMessage() + LoggerUtils.getStackTrace(e));
            Feeder.this.feederManager.setRepNodeShutdownException(EnvironmentFailureException.promote(Feeder.this.repNode.getRepImpl(), EnvironmentFailureReason.UNCAUGHT_EXCEPTION, "Uncaught exception in feeder thread:" + t, e));
            Feeder.this.repNode.interrupt();
        }
    }

    private class OutputThread
    extends StoppableThread {
        private long lastHeartbeat;
        Protocol protocol;
        private long totalTransferDelay;
        private long shutdownRequestStart;
        private final RepImpl threadRepImpl;

        OutputThread(RepImpl repImpl) {
            super(repImpl, new IOThreadsHandler());
            this.lastHeartbeat = 0L;
            this.protocol = null;
            this.totalTransferDelay = 0L;
            this.shutdownRequestStart = 0L;
            this.threadRepImpl = repImpl;
        }

        private boolean checkShutdown() throws IOException {
            if (!Feeder.this.shutdown.get()) {
                return false;
            }
            if (Feeder.this.repNode.getReplicaCloseCatchupMs() >= 0L) {
                boolean timedOut;
                if (this.shutdownRequestStart == 0L) {
                    this.shutdownRequestStart = System.currentTimeMillis();
                }
                boolean bl = timedOut = System.currentTimeMillis() - this.shutdownRequestStart > Feeder.this.repNode.getReplicaCloseCatchupMs();
                if (!timedOut && Feeder.this.feederVLSN.compareTo(Feeder.this.repNode.getCurrentCommitVLSN()) < 0) {
                    return false;
                }
                Protocol protocol = this.protocol;
                protocol.getClass();
                this.protocol.write((BinaryProtocol.Message)new Protocol.ShutdownRequest(protocol, this.shutdownRequestStart), Feeder.this.feederReplicaChannel);
                String shutdownMessage = String.format("Shutdown message sent to: %s  Shutdown elapsed time: %,dms", Feeder.this.replicaNameIdPair, System.currentTimeMillis() - this.shutdownRequestStart);
                LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, shutdownMessage);
                return true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Exception shutdownException;
            block19: {
                Thread.currentThread().setName("Feeder Output ");
                this.protocol = Protocol.get(Feeder.this.repNode, Feeder.this.protocolVersion);
                Thread.currentThread().setName("Feeder Output for " + Feeder.this.getReplicaNameIdPair().getName());
                int testDelayMs = Feeder.this.feederManager.getTestDelayMs();
                if (testDelayMs > 0) {
                    LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Test delay of:" + testDelayMs + "ms." + " after each message sent");
                }
                VLSNRange range = Feeder.this.repNode.getVLSNIndex().getRange();
                LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, String.format("Feeder output thread for replica %s started at VLSN %,d master at %,d VLSN delta=%,d socket=%s", Feeder.this.replicaNameIdPair.getName(), Feeder.this.feederVLSN.getSequence(), range.getLast().getSequence(), range.getLast().getSequence() - Feeder.this.feederVLSN.getSequence(), Feeder.this.feederReplicaChannel));
                Error feederOutputError = null;
                shutdownException = null;
                try {
                    try {
                        this.sendHeartbeat();
                        while (!this.checkShutdown()) {
                            if (Feeder.this.feederVLSN.compareTo(Feeder.this.repNode.getCurrentCommitVLSN()) >= 0) {
                                Feeder.this.repNode.passivatePrimary();
                            }
                            OutputWireRecord record = Feeder.this.feederSource.getWireRecord(Feeder.this.feederVLSN, Feeder.this.heartbeatInterval);
                            Feeder.this.masterStatus.assertSync();
                            if (record == null) {
                                this.sendHeartbeat();
                            } else {
                                BinaryProtocol.Message entry = this.createMessage(record);
                                this.validate(record);
                                this.maybeSpray(entry, record);
                                this.protocol.write(entry, Feeder.this.feederReplicaChannel);
                                this.sendHeartbeat();
                                Feeder.this.feederVLSN = Feeder.this.feederVLSN.getNext();
                            }
                            if (testDelayMs <= 0) continue;
                            Thread.sleep(testDelayMs);
                        }
                        Object var7_11 = null;
                        if (feederOutputError == null) break block19;
                        throw feederOutputError;
                    }
                    catch (IOException e) {
                        shutdownException = e;
                        Object var7_12 = null;
                        if (feederOutputError != null) {
                            throw feederOutputError;
                        }
                        LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentCommitVLSN: " + Feeder.this.repNode.getCurrentCommitVLSN());
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (MasterStatus.MasterSyncException e) {
                        shutdownException = e;
                        Object var7_13 = null;
                        if (feederOutputError != null) {
                            throw feederOutputError;
                        }
                        LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentCommitVLSN: " + Feeder.this.repNode.getCurrentCommitVLSN());
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (InterruptedException e) {
                        shutdownException = e;
                        Object var7_14 = null;
                        if (feederOutputError != null) {
                            throw feederOutputError;
                        }
                        LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentCommitVLSN: " + Feeder.this.repNode.getCurrentCommitVLSN());
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (RuntimeException e) {
                        shutdownException = e;
                        LoggerUtils.severe(Feeder.this.logger, this.threadRepImpl, "Unexpected exception: " + e.getMessage() + LoggerUtils.getStackTrace(e));
                        throw e;
                    }
                    catch (Error e) {
                        feederOutputError = e;
                        Feeder.this.repNode.getRepImpl().invalidate(e);
                        Object var7_15 = null;
                        if (feederOutputError != null) {
                            throw feederOutputError;
                        }
                        LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentCommitVLSN: " + Feeder.this.repNode.getCurrentCommitVLSN());
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_16 = null;
                    if (feederOutputError != null) {
                        throw feederOutputError;
                    }
                    LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentCommitVLSN: " + Feeder.this.repNode.getCurrentCommitVLSN());
                    Feeder.this.shutdown(shutdownException);
                    this.cleanup();
                    throw throwable;
                }
            }
            LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, "Feeder output for replica " + Feeder.this.replicaNameIdPair.getName() + " shutdown. feeder VLSN: " + Feeder.this.feederVLSN + " currentCommitVLSN: " + Feeder.this.repNode.getCurrentCommitVLSN());
            Feeder.this.shutdown(shutdownException);
            this.cleanup();
        }

        final void maybeSpray(BinaryProtocol.Message entry, OutputWireRecord record) throws IOException {
            if (--sprayAfterNMessagesCount == 0L) {
                if (record.getEntryType() != LogEntryType.LOG_LN_TRANSACTIONAL.getTypeNum()) {
                    sprayAfterNMessagesCount++;
                    return;
                }
                System.out.println("Initiating message spray: " + entry);
                while (true) {
                    this.protocol.write(entry, Feeder.this.feederReplicaChannel);
                }
            }
        }

        private void sendHeartbeat() throws IOException {
            long now = System.currentTimeMillis();
            long interval = now - this.lastHeartbeat;
            if (interval <= (long)Feeder.this.heartbeatInterval) {
                return;
            }
            VLSN vlsn = Feeder.this.repNode.getCurrentCommitVLSN();
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.protocol.write((BinaryProtocol.Message)new Protocol.Heartbeat(protocol, now, vlsn.getSequence()), Feeder.this.feederReplicaChannel);
            this.lastHeartbeat = now;
        }

        protected int initiateSoftShutdown() {
            RepUtils.shutdownChannel(Feeder.this.feederReplicaChannel);
            return Feeder.this.repNode.getThreadWaitInterval();
        }

        private BinaryProtocol.Message createMessage(OutputWireRecord wireRecord) throws DatabaseException {
            long txnId = wireRecord.getCommitTxnId();
            if (txnId != 0L) {
                MasterTxn ackTxn = Feeder.this.repNode.getFeederTxns().getAckTxn(txnId);
                if (ackTxn != null) {
                    ackTxn.stampRepWriteTime();
                    long messageTransferMs = ackTxn.messageTransferMs();
                    this.totalTransferDelay += messageTransferMs;
                    if (messageTransferMs > (long)TRANSFER_LOGGING_THRESHOLD_MS) {
                        LoggerUtils.info(Feeder.this.logger, this.threadRepImpl, String.format("Feeder for: %s, Txn: %,d  log to rep stream time %,dms. Total transfer time: %,dms.", Feeder.this.replicaNameIdPair.getName(), txnId, messageTransferMs, this.totalTransferDelay));
                    }
                }
                Durability.SyncPolicy replicaSync = ackTxn != null ? ackTxn.getCommitDurability().getReplicaSync() : Durability.SyncPolicy.NO_SYNC;
                Protocol protocol = this.protocol;
                protocol.getClass();
                return new Protocol.Commit(protocol, ackTxn != null, replicaSync, wireRecord);
            }
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Entry(protocol, wireRecord);
        }

        private void validate(OutputWireRecord record) {
            if (!record.getVLSN().equals(Feeder.this.feederVLSN)) {
                throw EnvironmentFailureException.unexpectedState("Expected VLSN:" + Feeder.this.feederVLSN + " log entry VLSN:" + record.getVLSN());
            }
            if (!this.threadRepImpl.isConverted()) assert (record.verifyNegativeSequences("node=" + Feeder.this.nameIdPair));
        }

        protected Logger getLogger() {
            return Feeder.this.logger;
        }
    }

    private class InputThread
    extends StoppableThread {
        Protocol protocol;
        private LocalCBVLSNUpdater replicaCBVLSN;

        InputThread(RepImpl repImpl) {
            super(repImpl, new IOThreadsHandler());
            this.protocol = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Exception shutdownException;
            block24: {
                Thread.currentThread().setName("Feeder Input ");
                Error feederInputError = null;
                shutdownException = null;
                try {
                    try {
                        FeederReplicaHandshake handshake = new FeederReplicaHandshake(Feeder.this.repNode, Feeder.this, Feeder.this.feederReplicaChannel);
                        try {
                            this.protocol = handshake.execute();
                        }
                        catch (InsufficientReplicasException e) {
                            Object var6_15 = null;
                            if (feederInputError != null) {
                                throw feederInputError;
                            }
                            Feeder.this.shutdown(shutdownException);
                            this.cleanup();
                            return;
                        }
                        catch (InsufficientAcksException e) {
                            Object var6_16 = null;
                            if (feederInputError != null) {
                                throw feederInputError;
                            }
                            Feeder.this.shutdown(shutdownException);
                            this.cleanup();
                            return;
                        }
                        Feeder.this.protocolVersion = this.protocol.getVersion();
                        Feeder.this.replicaNameIdPair = handshake.getReplicaNameIdPair();
                        Thread.currentThread().setName("Feeder Input for " + Feeder.this.replicaNameIdPair.getName());
                        FeederReplicaSyncup syncup = new FeederReplicaSyncup(Feeder.this, Feeder.this.feederReplicaChannel, this.protocol);
                        this.replicaCBVLSN = new LocalCBVLSNUpdater(Feeder.this.replicaNameIdPair, Feeder.this.repNode);
                        Feeder.this.feederVLSN = syncup.execute(this.replicaCBVLSN);
                        Feeder.this.feederSource.init(Feeder.this.feederVLSN);
                        Feeder.this.outputThread.start();
                        Feeder.this.lastResponseTime = System.currentTimeMillis();
                        Feeder.this.masterStatus.assertSync();
                        Feeder.this.feederManager.activateFeeder(Feeder.this);
                        this.runResponseLoop();
                    }
                    catch (FeederReplicaSyncup.NetworkRestoreException e) {
                        LoggerUtils.info(Feeder.this.logger, Feeder.this.repImpl, e.getMessage());
                        Object var6_18 = null;
                        if (feederInputError != null) {
                            throw feederInputError;
                        }
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (IOException e) {
                        shutdownException = e;
                        Object var6_19 = null;
                        if (feederInputError != null) {
                            throw feederInputError;
                        }
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (MasterStatus.MasterSyncException e) {
                        shutdownException = e;
                        Object var6_20 = null;
                        if (feederInputError != null) {
                            throw feederInputError;
                        }
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (InterruptedException e) {
                        shutdownException = e;
                        Object var6_21 = null;
                        if (feederInputError != null) {
                            throw feederInputError;
                        }
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (ExitException e) {
                        LoggerUtils.fine(Feeder.this.logger, Feeder.this.repImpl, "Exiting feeder loop: " + e.getMessage());
                        Object var6_22 = null;
                        if (feederInputError != null) {
                            throw feederInputError;
                        }
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (Error e) {
                        feederInputError = e;
                        Feeder.this.repNode.getRepImpl().invalidate(e);
                        Object var6_23 = null;
                        if (feederInputError != null) {
                            throw feederInputError;
                        }
                        Feeder.this.shutdown(shutdownException);
                        this.cleanup();
                        return;
                    }
                    catch (ChecksumException e) {
                        shutdownException = e;
                        throw new EnvironmentFailureException((EnvironmentImpl)Feeder.this.repNode.getRepImpl(), EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
                    }
                    catch (RuntimeException e) {
                        shutdownException = e;
                        LoggerUtils.severe(Feeder.this.logger, Feeder.this.repImpl, "Unexpected exception: " + e.getMessage() + LoggerUtils.getStackTrace(e));
                        throw e;
                    }
                    Object var6_17 = null;
                    if (feederInputError == null) break block24;
                    throw feederInputError;
                }
                catch (Throwable throwable) {
                    Object var6_24 = null;
                    if (feederInputError != null) {
                        throw feederInputError;
                    }
                    Feeder.this.shutdown(shutdownException);
                    this.cleanup();
                    throw throwable;
                }
            }
            Feeder.this.shutdown(shutdownException);
            this.cleanup();
        }

        private void runResponseLoop() throws IOException, MasterStatus.MasterSyncException {
            while (!this.checkShutdown()) {
                BinaryProtocol.Message response = this.protocol.read(Feeder.this.feederReplicaChannel);
                if (this.checkShutdown()) break;
                Feeder.this.masterStatus.assertSync();
                Feeder.this.lastResponseTime = System.currentTimeMillis();
                if (response.getOp() == Protocol.HEARTBEAT_RESPONSE) {
                    Protocol.HeartbeatResponse hbResponse = (Protocol.HeartbeatResponse)response;
                    this.replicaCBVLSN.updateForReplica(hbResponse);
                    continue;
                }
                if (response.getOp() == Protocol.ACK) {
                    long txnId = ((Protocol.Ack)response).getTxnId();
                    if (Feeder.this.logger.isLoggable(Level.FINE)) {
                        LoggerUtils.fine(Feeder.this.logger, Feeder.this.repImpl, "Ack for: " + txnId);
                    }
                    Feeder.this.repNode.getFeederTxns().noteReplicaAck(txnId);
                    continue;
                }
                if (response.getOp() == Protocol.SHUTDOWN_RESPONSE) {
                    LoggerUtils.info(Feeder.this.logger, Feeder.this.repImpl, "Shutdown confirmed by replica " + Feeder.this.replicaNameIdPair.getName());
                    break;
                }
                throw EnvironmentFailureException.unexpectedState("Unexpected message: " + response);
            }
        }

        private boolean checkShutdown() {
            return Feeder.this.shutdown.get() && Feeder.this.repNode.getReplicaCloseCatchupMs() < 0L;
        }

        protected int initiateSoftShutdown() {
            RepUtils.shutdownChannel(Feeder.this.feederReplicaChannel);
            return Feeder.this.repNode.getThreadWaitInterval();
        }

        protected Logger getLogger() {
            return Feeder.this.logger;
        }
    }
}

