package csl.tools.thread;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class MyThreadPoolPane extends JPanel implements PropertyChangeListener {

	private static final long	serialVersionUID	= -4630817734260857969L;
	private JProgressBar		progressBar;

	/**
	 * This is the default constructor
	 */
	public MyThreadPoolPane() {

		super();
		initialize();
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		this.setLayout(new GridBagLayout());
		this.setSize(350, 200);
	}

	private JProgressBar getProgressBar() {

		if (progressBar == null) {
			progressBar = new JProgressBar();
		}
		return progressBar;
	}

	public void setPool(MyThreadPool pool) {

		/*
		 * Register this as a listener of the pool
		 */
		pool.addListener(this);

		/*
		 * Adds thread status panels to check the status of each thread
		 */
		int i = 0;
		for (Object th : pool.getThreads()) {
			MyThreadStatusPane p = new MyThreadStatusPane();
			p.setThread((MyThread) th);
			GridBagConstraints gridBagConstraints = new GridBagConstraints();
			gridBagConstraints.gridx = 0;
			gridBagConstraints.gridy = i++;
			this.add(p, gridBagConstraints);
		}

		/*
		 * Progress bar
		 */
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = i++;
		getProgressBar().setMinimum(0);
		getProgressBar().setValue(0);
		getProgressBar().setMaximum(pool.getItemCount());
		this.add(getProgressBar(), gridBagConstraints);
	}

	public void propertyChange(PropertyChangeEvent evt) {

	}

	public void increaseProgressBy(int i) {

		getProgressBar().setValue(getProgressBar().getValue() + i);
	}

}
