package csl.tools.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;

import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

abstract public class CslJList extends JList {

	private static final long	serialVersionUID	= 4769991541438830712L;
	protected static final int	CTRL_F				= 70;
	protected static final int	CTRL_L				= 76;
	protected static final int	CTRL_S				= 83;
	protected static final int	CTRL_X				= 88;
	protected static final int	F5					= 116;
	protected static final int	SPACE				= 32;
	protected static final int	REMOVE				= 127;
	private JPopupMenu			rightMouseButtonMenu;
	private JMenuItem			removeMenuItem;
	private JMenuItem			loadListMenuItem;
	private JMenuItem			saveListMenuItem;
	private JMenuItem			exportListMenuItem;
	private JMenuItem			importListMenuItem;
	private JMenuItem			renameMenuItem;

	public CslJList() {

		super();
		init();
	}

	private void init() {

		setModel(new DefaultListModel());
		addMouseListener(new MouseAdapter() {

			@Override
			public void mouseClicked(MouseEvent e) {

				if (e.getButton() == MouseEvent.BUTTON3) {
					getRightMouseButtonMenu().show(e.getComponent(), e.getX(),
							e.getY());
				}
			}

		});
		addKeyListener(new KeyAdapter() {

			@Override
			public void keyPressed(KeyEvent e) {

				try {
					int keyCode = e.getKeyCode();

					CslJList.this.keyPressed(keyCode);
				} catch (ArrayIndexOutOfBoundsException exc) {
				}

			}
		});
	}

	private DefaultListModel getDefaultModel() {

		return (DefaultListModel) getModel();
	}

	protected JPopupMenu getRightMouseButtonMenu() {

		if (rightMouseButtonMenu == null) {
			rightMouseButtonMenu = new JPopupMenu();
			rightMouseButtonMenu.add(getRemoveMenuItem());
			rightMouseButtonMenu.addSeparator();
			rightMouseButtonMenu.add(getLoadListMenuItem());
			rightMouseButtonMenu.add(getSaveListMenuItem());
			rightMouseButtonMenu.addSeparator();
			rightMouseButtonMenu.add(getImportListMenuItem());
			rightMouseButtonMenu.add(getExportListMenuItem());
			if (getAdditionalMenuItem() != null
					&& getAdditionalMenuItem().size() > 0) {
				rightMouseButtonMenu.addSeparator();
				for (JMenuItem menuItem : getAdditionalMenuItem()) {

					rightMouseButtonMenu.add(menuItem);
				}
			}
		}
		return rightMouseButtonMenu;
	}

	abstract public List<JMenuItem> getAdditionalMenuItem();

	private JMenuItem getRemoveMenuItem() {

		if (removeMenuItem == null) {
			removeMenuItem = new JMenuItem("remove");
			removeMenuItem.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {

					removeSelectedItems();
				}
			});
		}
		return removeMenuItem;
	}

	private JMenuItem getLoadListMenuItem() {

		if (loadListMenuItem == null) {
			loadListMenuItem = new JMenuItem("load");
			loadListMenuItem.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {

					loadList();
				}
			});
		}
		return loadListMenuItem;
	}

	private JMenuItem getSaveListMenuItem() {

		if (saveListMenuItem == null) {
			saveListMenuItem = new JMenuItem("save");
			saveListMenuItem.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {

					saveList();
				}
			});
		}
		return saveListMenuItem;
	}

	private JMenuItem getImportListMenuItem() {

		if (importListMenuItem == null) {
			importListMenuItem = new JMenuItem("import");
			importListMenuItem.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {

					importList();
				}
			});
		}
		return importListMenuItem;
	}

	private JMenuItem getExportListMenuItem() {

		if (exportListMenuItem == null) {
			exportListMenuItem = new JMenuItem("export");
			exportListMenuItem.addActionListener(new ActionListener() {

				public void actionPerformed(ActionEvent e) {

					exportList();
				}
			});
		}
		return exportListMenuItem;
	}

	protected void removeSelectedItems() {

		for (Object obj : getSelectedValues()) {
			getDefaultModel().removeElement(obj);
		}
	}

	protected void loadList() {

		// TODO Auto-generated method stub

	}

	protected void saveList() {

		// TODO Auto-generated method stub

	}

	protected void importList() {

		// TODO Auto-generated method stub

	}

	protected void exportList() {

		// TODO Auto-generated method stub

	}

	protected void keyPressed(int keyCode) {

		switch (keyCode) {
		case CTRL_X:
			removeSelectedItems();
			break;
		case REMOVE:
			removeSelectedItems();
			break;
		case CTRL_S:
			saveList();
			break;
		case CTRL_L:
			loadList();
			break;
		default:
			return;
		}
	}

}
