package csl.tools.algos;

public class Edge {

	private Vertex start, end;

	private double cost, cost2;

	public final double initialCost;

	public Edge(double c) {

		super();
		cost = c;
		initialCost = c;
	}

	public void swapCosts() {
		if (cost == cost2) {
			System.err.println("Should not happen");
		}
		double tmp = cost;
		cost = cost2;
		cost2 = tmp;
	}

	public void setCost(double c) {
		cost = c;
	}

	public double cost() {
		return cost;
	}

	public void setStart(Vertex v) {
		start = v;
		start.edges.add(this);
		if (start.isBattery)
			cost2 = 10000;
		else
			cost2 = initialCost;
		if(start.isBattery)
			swapCosts();
	}

	public void setEnd(Vertex v) {
		end = v;
	}

	@Override
	public String toString() {

		return start + " --> " + end + "(" + cost + ")";
	}

	public boolean endsWith(Vertex v) {
		return end == v;
	}

	public Vertex getEnd() {

		return end;
	}

	public Vertex getStart() {

		return start;
	}

	public void increaseCost(double d) {

		setCost(cost() + d);
	}

}
