package csl.tools.algos;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class AllPathAlgo<T> {

	private Hashtable<T, List<T>>	transitions;

	public AllPathAlgo(Hashtable<T, List<T>> transitions) {

		this.transitions = transitions;
	}

	public List<T> children(T t) {

		List<T> tval = transitions.get(t);
		if (tval == null)
			return new Vector<T>();
		return tval;
	}

	public List<T> ancestors(T t) {

		Enumeration<T> kEnum = transitions.keys();
		List<T> result = new Vector<T>();
		while (kEnum.hasMoreElements()) {
			T key = kEnum.nextElement();
			List<T> value = transitions.get(key);
			if (value.contains(t))
				result.add(key);
		}
		return result;
	}

	public List<T> ancestorsNotIn(T t, List<T> forbidden) {

		List<T> ancestors = ancestors(t);
		for (T ancestor : forbidden)
			ancestors.remove(ancestor);
		return ancestors;
	}

	public void allPaths(T src, T dest, int length, List<Path<T>> results) {

		if (length < 0)
			return;
		T t = dest;
		for (T ancestor : ancestors(t)) {
			if (ancestor == src)
				results.add(new Path<T>(src, dest));

			List<Path<T>> res = new Vector<Path<T>>();
			allPaths(ancestor, dest, length - 1, res);
			for (Path<T> path : res)
				results.add(new Path<T>(src, path));
		}
	}
}
