/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import java.io.IOException;

public class LatchedLogManager
extends LogManager {
    public LatchedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    private boolean acquireLogWriteLatch() throws DatabaseException {
        if (this.logWriteLatch.isOwner()) {
            return false;
        }
        this.logWriteLatch.acquire();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialLog(LogItem[] itemArray, LogContext context) throws IOException, DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.serialLogInternal(itemArray, context);
            Object var5_4 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInternal() throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.logBufferPool.writeBufferToFile(0, false);
            Object var3_2 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedFileSummary getUnflushableTrackedSummary(long file) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            TrackedFileSummary trackedFileSummary = this.getUnflushableTrackedSummaryInternal(file);
            Object var6_4 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            return trackedFileSummary;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_5 = null;
                if (!releaseLogWriteLatch) break block3;
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrackedFile(TrackedFileSummary tfs) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.removeTrackedFileInternal(tfs);
            Object var4_3 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNode(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb, boolean countExact) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.countObsoleteNodeInternal(lsn, type, size, nodeDb, countExact);
            Object var9_7 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteNodeDupsAllowed(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.countObsoleteNodeDupsAllowedInternal(lsn, type, size, nodeDb);
            Object var8_6 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferToUtilizationTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.transferToUtilizationTrackerInternal(localTracker);
            Object var4_3 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void countObsoleteDb(DatabaseImpl db) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.countObsoleteDbInternal(db);
            Object var4_3 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDbFileSummary(DatabaseImpl db, Long fileNum) throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            boolean bl = this.removeDbFileSummaryInternal(db, fileNum);
            Object var6_5 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (!releaseLogWriteLatch) break block3;
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadEndOfLogStat() throws DatabaseException {
        boolean releaseLogWriteLatch = this.acquireLogWriteLatch();
        try {
            this.loadEndOfLogStatInternal();
            Object var3_2 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (releaseLogWriteLatch) {
                this.logWriteLatch.release();
            }
            throw throwable;
        }
    }
}

