package csl.tools.prefs;

import java.awt.BorderLayout;
import java.awt.Button;
import java.io.File;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

import csl.tools.files.FileTools;
import csl.tools.gui.StatusBar;

public class PrefManPanel extends JPanel {

	private static final long	serialVersionUID	= 6251526568939132088L;
	private StatusBar			statusBar			= null;
	private JToolBar			toolBar				= null;
	private Button				loadButton			= null;
	private DefaultTableModel	prefTableModel		= null;
	PreferenceManager			prefMan				= null;
	private TableModelListener	listener			= null;
	private JScrollPane			jScrollPane			= null;
	private JTable				jTable				= null;
	private boolean				showToolBar			= true;

	/**
	 * This is the default constructor
	 */
	public PrefManPanel() {

		this(true);
	}

	public PrefManPanel(boolean showToolbar) {

		super();
		this.showToolBar = showToolbar;
		initialize();
	}

	public void setShowToolBar(boolean b) {

		showToolBar = b;
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		this.setLayout(new BorderLayout());
		this.setSize(398, 312);
		this.add(getStatusBar(), java.awt.BorderLayout.SOUTH);
		if (showToolBar)
			this.add(getToolBar(), java.awt.BorderLayout.NORTH);
		this.add(getJScrollPane(), java.awt.BorderLayout.CENTER);
	}

	private DefaultTableModel getPrefTableModel() {

		if (prefTableModel == null) {
			prefTableModel = new PrefTableModel();
			prefTableModel.addColumn("Key");
			prefTableModel.addColumn("Value");
			prefTableModel.addTableModelListener(getTableModelListener());
		}
		return prefTableModel;
	}

	private TableModelListener getTableModelListener() {

		if (listener == null) {
			listener = new TableModelListener() {

				public void tableChanged(TableModelEvent e) {

					if (e.getType() == TableModelEvent.UPDATE) {
						int r = e.getFirstRow();
						PrefTableModel t = (PrefTableModel) e.getSource();
						prefMan.set((String) t.getValueAt(r, 0), (String) t
								.getValueAt(r, 1));
					}
					if (e.getType() == TableModelEvent.INSERT) {

					}
					if (e.getType() == TableModelEvent.INSERT) {

					}
					if (e.getType() == TableModelEvent.DELETE) {

					}
				}
			};
		}
		return listener;
	}

	/**
	 * This method initializes statusBar
	 * 
	 * @return csl.tools.gui.StatusBar
	 */
	private StatusBar getStatusBar() {

		if (statusBar == null) {
			statusBar = new StatusBar();
			statusBar.setEraseDelay(100);
		}
		return statusBar;
	}

	/**
	 * This method initializes toolBar
	 * 
	 * @return javax.swing.JToolBar
	 */
	private JToolBar getToolBar() {

		if (toolBar == null) {
			toolBar = new JToolBar();
			toolBar.add(getLoadButton());
		}
		return toolBar;
	}

	/**
	 * This method initializes loadButton
	 * 
	 * @return java.awt.Button
	 */
	private Button getLoadButton() {

		if (loadButton == null) {
			loadButton = new Button();
			loadButton.setLabel("load");
			loadButton.addActionListener(new java.awt.event.ActionListener() {

				public void actionPerformed(java.awt.event.ActionEvent e) {

					loadPreferences();
				}
			});
		}
		return loadButton;
	}

	protected void loadPreferences() {

		printStatus("Choose a preference file to load");
		File file = FileTools.chooseFile("preferences");
		if (file == null)
			return;
		loadPreferences(file);
	}

	public void loadPreferences(File file) {

		prefMan = new PreferenceManager(file, null);
		printStatus("Loading preference set: " + prefMan.outputFile.getName());
		while (getPrefTableModel().getRowCount() > 0)
			getPrefTableModel().removeRow(0);
		for (String key : prefMan.stringPropertyNames())
			getPrefTableModel().addRow(new String[] { key, prefMan.get(key) });
		printStatus("Preferences loaded");
		repaint();
	}

	private void printStatus(String msg) {

		getStatusBar().newMessage(msg);
	}

	/**
	 * This method initializes jScrollPane
	 * 
	 * @return javax.swing.JScrollPane
	 */
	private JScrollPane getJScrollPane() {

		if (jScrollPane == null) {
			jScrollPane = new JScrollPane();
			jScrollPane
					.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
			jScrollPane
					.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);
			jScrollPane.setViewportView(getJTable());
		}
		return jScrollPane;
	}

	/**
	 * This method initializes jTable
	 * 
	 * @return javax.swing.JTable
	 */
	private JTable getJTable() {

		if (jTable == null) {
			jTable = new JTable(getPrefTableModel());
			jTable.setAutoCreateRowSorter(true);
		}
		return jTable;
	}

} // @jve:decl-index=0:visual-constraint="31,6"
