package csl.tools.threads;

import java.util.List;
import java.util.Vector;

import javax.swing.SwingWorker;

public abstract class OneThread<V> extends SwingWorker<List<V>, V> {

	private ThreadPool	pool;
	public String		name;

	protected OneThread(String name, ThreadPool pool) {

		this.name = name;
		this.pool = pool;
		addPropertyChangeListener(pool);
	}

	@SuppressWarnings("unchecked")
	@Override
	protected List<V> doInBackground() throws Exception {

		List<V> list = new Vector<V>();
		while (pool.hasMoreItems()) {
			V item = (V) pool.nextItem();
			list.add(item);
			process(item);
		}
		return list;
	}

	@SuppressWarnings("unchecked")
	protected void process(V... chunks) {

		for (V v : chunks) {
			processOne(v);
			pool.oneDone(this, v);
		}
	}

	public abstract void processOne(V e);

	@Override
	public String toString() {

		return name;
	}
}
