package csl.tools.thread;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JPanel;
import javax.swing.JTextField;

public class MyThreadStatusPane extends JPanel implements
		PropertyChangeListener {

	private static final long	serialVersionUID	= 3463811211406439693L;
	private JTextField			statusTextField		= null;
	private MyThread			thread;
	private JTextField			countTextField		= null;

	/**
	 * This is the default constructor
	 */
	public MyThreadStatusPane() {

		super();
		initialize();
	}

	void setThread(MyThread th) {

		thread = th;
		thread.addPropertyChangeListener(this);
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
		gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints1.gridy = 0;
		gridBagConstraints1.ipady = 5;
		gridBagConstraints1.weightx = 1.0;
		gridBagConstraints1.gridx = 1;
		GridBagConstraints gridBagConstraints = new GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.ipadx = 0;
		gridBagConstraints.ipady = 5;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.gridx = 0;
		this.setLayout(new GridBagLayout());
		this.setPreferredSize(new Dimension(179, 25));
		this.add(getStatusTextField(), gridBagConstraints);
		this.add(getCountTextField(), gridBagConstraints1);
	}

	/**
	 * This method initializes statusTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getStatusTextField() {

		if (statusTextField == null) {
			statusTextField = new JTextField();
			statusTextField.setPreferredSize(new java.awt.Dimension(40, 20));
		}
		return statusTextField;
	}

	/**
	 * This method initializes countTextField
	 * 
	 * @return javax.swing.JTextField
	 */
	private JTextField getCountTextField() {

		if (countTextField == null) {
			countTextField = new JTextField();
			countTextField.setPreferredSize(new java.awt.Dimension(40, 20));
		}
		return countTextField;
	}

	public void propertyChange(PropertyChangeEvent evt) {

		if (evt.getPropertyName().equals("state")) {
			getStatusTextField().setText(evt.getNewValue().toString());
		} else if (evt.getPropertyName().equals("progress")) {
			getCountTextField().setText(evt.getNewValue().toString());
		}
	}

} // @jve:decl-index=0:visual-constraint="10,10"
