/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.VLSN;
import java.util.concurrent.TimeUnit;

public class PointConsistencyPolicy
implements ReplicaConsistencyPolicy {
    public static final String NAME = "PointConsistencyPolicy";
    private final VLSN targetVLSN;
    private final int timeout;

    public PointConsistencyPolicy(VLSN targetVLSN) {
        this(targetVLSN, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public PointConsistencyPolicy(VLSN targetVLSN, long timeout, TimeUnit timeoutUnit) {
        this.targetVLSN = targetVLSN;
        this.timeout = PropUtil.durationToMillis(timeout, timeoutUnit);
    }

    public String getName() {
        return NAME;
    }

    public void ensureConsistency(EnvironmentImpl replicatorImpl) throws InterruptedException, ReplicaConsistencyException, DatabaseException {
        RepImpl repImpl = (RepImpl)replicatorImpl;
        Replica replica = repImpl.getRepNode().replica();
        replica.getConsistencyTracker().anyVLSNAwait(this.targetVLSN.getSequence(), this);
    }

    public long getTimeout(TimeUnit unit) {
        return PropUtil.millisToDuration(this.timeout, unit);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetVLSN == null ? 0 : this.targetVLSN.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PointConsistencyPolicy other = (PointConsistencyPolicy)obj;
        return !(this.targetVLSN == null ? other.targetVLSN != null : !this.targetVLSN.equals(other.targetVLSN));
    }
}

