/*
 * Decompiled with CFR 0.152.
 */
package core;

import core.Tag;
import core.TransformableItem;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.Hashtable;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class TagCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -1720518232138727560L;
    private TransformableItem item;
    private Hashtable<Tag, Float> tagValues = new Hashtable();
    static DecimalFormat dcSimple = new DecimalFormat("0.00");
    static DecimalFormat dcComplete = new DecimalFormat("0.000E0");

    public TagCellRenderer(TransformableItem t) {
        this.item = t;
    }

    public void setItem(TransformableItem t) {
        this.item = t;
        this.tagValues = new Hashtable();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Tag tag = (Tag)value;
        this.setText(String.valueOf(tag.getName()) + "(" + dcSimple.format(this.getValueFor(tag)) + " / " + dcComplete.format(this.getValueFor(tag)) + ")\n");
        return this;
    }

    float getValueFor(Tag t) {
        if (this.item == null) {
            return 0.0f;
        }
        Float val = this.tagValues.get(t);
        if (val == null) {
            val = new Float(t.classifyScalar(this.item));
            this.tagValues.put(t, val);
        }
        return val.floatValue();
    }
}

