/*
 * Decompiled with CFR 0.152.
 */
package weka.core.tokenizers;

import java.util.NoSuchElementException;
import weka.core.tokenizers.Tokenizer;

public class AlphabeticTokenizer
extends Tokenizer {
    private static final long serialVersionUID = 6705199562609861697L;
    protected char[] m_Str;
    protected int m_CurrentPos;

    public String globalInfo() {
        return "Alphabetic string tokenizer, tokens are to be formed only from contiguous alphabetic sequences.";
    }

    public boolean hasMoreElements() {
        int n;
        for (n = this.m_CurrentPos; !(n >= this.m_Str.length || this.m_Str[n] >= 'a' && this.m_Str[n] <= 'z' || this.m_Str[n] >= 'A' && this.m_Str[n] <= 'Z'); ++n) {
        }
        this.m_CurrentPos = n;
        return n < this.m_Str.length && (this.m_Str[n] >= 'a' && this.m_Str[n] <= 'z' || this.m_Str[n] >= 'A' && this.m_Str[n] <= 'Z');
    }

    public Object nextElement() {
        int n;
        int n2;
        for (n2 = this.m_CurrentPos; n2 < this.m_Str.length && this.m_Str[n2] < 'a' && this.m_Str[n2] > 'z' && this.m_Str[n2] < 'A' && this.m_Str[n2] > 'Z'; ++n2) {
        }
        this.m_CurrentPos = n = n2;
        if (n2 >= this.m_Str.length) {
            throw new NoSuchElementException("No more tokens present");
        }
        while (n < this.m_Str.length && (this.m_Str[n] >= 'a' && this.m_Str[n] <= 'z' || this.m_Str[n] >= 'A' && this.m_Str[n] <= 'Z')) {
            ++n;
        }
        String string = new String(this.m_Str, n2, n - this.m_CurrentPos);
        this.m_CurrentPos = n;
        return string;
    }

    public void tokenize(String string) {
        this.m_CurrentPos = 0;
        this.m_Str = new char[string.length()];
        string.getChars(0, string.length(), this.m_Str, 0);
    }

    public static void main(String[] stringArray) {
        AlphabeticTokenizer.runTokenizer(new AlphabeticTokenizer(), stringArray);
    }
}

