/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.Utils;

public class C45ModelSelection
extends ModelSelection {
    private static final long serialVersionUID = 3372204862440821989L;
    private int m_minNoObj;
    private Instances m_allData;

    public C45ModelSelection(int n, Instances instances) {
        this.m_minNoObj = n;
        this.m_allData = instances;
    }

    public void cleanup() {
        this.m_allData = null;
    }

    public final ClassifierSplitModel selectModel(Instances instances) {
        ClassifierSplitModel classifierSplitModel = null;
        NoSplit noSplit = null;
        double d = 0.0;
        int n = 0;
        boolean bl = true;
        try {
            int n2;
            Distribution distribution = new Distribution(instances);
            noSplit = new NoSplit(distribution);
            if (Utils.sm(distribution.total(), 2 * this.m_minNoObj) || Utils.eq(distribution.total(), distribution.perClass(distribution.maxClass()))) {
                return noSplit;
            }
            if (this.m_allData != null) {
                Enumeration enumeration = instances.enumerateAttributes();
                while (enumeration.hasMoreElements()) {
                    Attribute attribute = (Attribute)enumeration.nextElement();
                    if (!attribute.isNumeric() && !Utils.sm(attribute.numValues(), 0.3 * (double)this.m_allData.numInstances())) continue;
                    bl = false;
                    break;
                }
            }
            C45Split[] c45SplitArray = new C45Split[instances.numAttributes()];
            double d2 = instances.sumOfWeights();
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                if (n2 != instances.classIndex()) {
                    c45SplitArray[n2] = new C45Split(n2, this.m_minNoObj, d2);
                    c45SplitArray[n2].buildClassifier(instances);
                    if (!c45SplitArray[n2].checkModel()) continue;
                    if (this.m_allData != null) {
                        if (!instances.attribute(n2).isNumeric() && !bl && !Utils.sm(instances.attribute(n2).numValues(), 0.3 * (double)this.m_allData.numInstances())) continue;
                        d += c45SplitArray[n2].infoGain();
                        ++n;
                        continue;
                    }
                    d += c45SplitArray[n2].infoGain();
                    ++n;
                    continue;
                }
                c45SplitArray[n2] = null;
            }
            if (n == 0) {
                return noSplit;
            }
            d /= (double)n;
            double d3 = 0.0;
            for (n2 = 0; n2 < instances.numAttributes(); ++n2) {
                if (n2 == instances.classIndex() || !c45SplitArray[n2].checkModel() || !(c45SplitArray[n2].infoGain() >= d - 0.001) || !Utils.gr(c45SplitArray[n2].gainRatio(), d3)) continue;
                classifierSplitModel = c45SplitArray[n2];
                d3 = c45SplitArray[n2].gainRatio();
            }
            if (Utils.eq(d3, 0.0)) {
                return noSplit;
            }
            classifierSplitModel.distribution().addInstWithUnknown(instances, ((C45Split)classifierSplitModel).attIndex());
            if (this.m_allData != null) {
                ((C45Split)classifierSplitModel).setSplitPoint(this.m_allData);
            }
            return classifierSplitModel;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final ClassifierSplitModel selectModel(Instances instances, Instances instances2) {
        return this.selectModel(instances);
    }
}

