package csl.tools.parallel;

public class ForPThread<E, F> extends Thread {

	private ForPThreadActivityPane myActivityPane = null;

	final private String myName;
	protected ForP<E, F> father;

	public ForPThread(String name, ForP<E, F> parent) {

		super();
		this.myName = name;
		this.father = parent;
//		this.setPriority(Thread.MIN_PRIORITY);
	}

	public ForPThreadActivityPane getMyActivityPane() {

		return myActivityPane;
	}

	public void setMyActivityPane(ForPThreadActivityPane p) {

		this.myActivityPane = p;
	}

	public void blink() {

		if (myActivityPane != null)
			myActivityPane.blink();
	}

	private void setCreated() {

		if (myActivityPane != null)
			myActivityPane.setCreated();
	}

	private void setStarted() {

		if (myActivityPane != null)
			myActivityPane.setStarted();
	}

	protected void setDone() {

		if (myActivityPane != null)
			myActivityPane.setDone();
	}

	public void setActivityPane(ForPActivityPane activityPane) {

		if (myActivityPane != null) {
			System.err.println("Activity pane already set");
			return;
		}
		ForPThreadActivityPane p = new ForPThreadActivityPane();
		activityPane.addThreadActivityPane(p);
		setMyActivityPane(p);
		setCreated();
	}

	public void start(boolean showActivity) {

		setStarted();
		start();
	}

	@Override
	public String toString() {
		return "SubTh: " + myName;
	}
}