/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.util;

public class PackedInteger {
    public static final int MAX_LENGTH = 5;
    public static final int MAX_LONG_LENGTH = 9;

    public static int readInt(byte[] buf, int off) {
        int byteLen;
        boolean negative;
        byte b1;
        if ((b1 = buf[off++]) < -119) {
            negative = true;
            byteLen = -b1 - 119;
        } else if (b1 > 119) {
            negative = false;
            byteLen = b1 - 119;
        } else {
            return b1;
        }
        int value = buf[off++] & 0xFF;
        if (byteLen > 1) {
            value |= (buf[off++] & 0xFF) << 8;
            if (byteLen > 2) {
                value |= (buf[off++] & 0xFF) << 16;
                if (byteLen > 3) {
                    value |= (buf[off++] & 0xFF) << 24;
                }
            }
        }
        return negative ? -value - 119 : value + 119;
    }

    public static long readLong(byte[] buf, int off) {
        int byteLen;
        boolean negative;
        byte b1;
        if ((b1 = buf[off++]) < -119) {
            negative = true;
            byteLen = -b1 - 119;
        } else if (b1 > 119) {
            negative = false;
            byteLen = b1 - 119;
        } else {
            return b1;
        }
        long value = (long)buf[off++] & 0xFFL;
        if (byteLen > 1) {
            value |= ((long)buf[off++] & 0xFFL) << 8;
            if (byteLen > 2) {
                value |= ((long)buf[off++] & 0xFFL) << 16;
                if (byteLen > 3) {
                    value |= ((long)buf[off++] & 0xFFL) << 24;
                    if (byteLen > 4) {
                        value |= ((long)buf[off++] & 0xFFL) << 32;
                        if (byteLen > 5) {
                            value |= ((long)buf[off++] & 0xFFL) << 40;
                            if (byteLen > 6) {
                                value |= ((long)buf[off++] & 0xFFL) << 48;
                                if (byteLen > 7) {
                                    value |= ((long)buf[off++] & 0xFFL) << 56;
                                }
                            }
                        }
                    }
                }
            }
        }
        return negative ? -value - 119L : value + 119L;
    }

    public static int getReadIntLength(byte[] buf, int off) {
        byte b1 = buf[off];
        if (b1 < -119) {
            return -b1 - 119 + 1;
        }
        if (b1 > 119) {
            return b1 - 119 + 1;
        }
        return 1;
    }

    public static int getReadLongLength(byte[] buf, int off) {
        return PackedInteger.getReadIntLength(buf, off);
    }

    public static int writeInt(byte[] buf, int offset, int value) {
        boolean negative;
        int byte1Off = offset;
        if (value < -119) {
            negative = true;
            value = -value - 119;
        } else if (value > 119) {
            negative = false;
            value -= 119;
        } else {
            buf[offset++] = (byte)value;
            return offset;
        }
        int n = ++offset;
        ++offset;
        buf[n] = (byte)value;
        if ((value & 0xFFFFFF00) == 0) {
            buf[byte1Off] = negative ? -120 : 120;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 8);
        if ((value & 0xFFFF0000) == 0) {
            buf[byte1Off] = negative ? -121 : 121;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 16);
        if ((value & 0xFF000000) == 0) {
            buf[byte1Off] = negative ? -122 : 122;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 24);
        buf[byte1Off] = negative ? -123 : 123;
        return offset;
    }

    public static int writeLong(byte[] buf, int offset, long value) {
        boolean negative;
        int byte1Off = offset;
        if (value < -119L) {
            negative = true;
            value = -value - 119L;
        } else if (value > 119L) {
            negative = false;
            value -= 119L;
        } else {
            buf[offset++] = (byte)value;
            return offset;
        }
        int n = ++offset;
        ++offset;
        buf[n] = (byte)value;
        if ((value & 0xFFFFFFFFFFFFFF00L) == 0L) {
            buf[byte1Off] = negative ? -120 : 120;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 8);
        if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
            buf[byte1Off] = negative ? -121 : 121;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 16);
        if ((value & 0xFFFFFFFFFF000000L) == 0L) {
            buf[byte1Off] = negative ? -122 : 122;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 24);
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            buf[byte1Off] = negative ? -123 : 123;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 32);
        if ((value & 0xFFFFFF0000000000L) == 0L) {
            buf[byte1Off] = negative ? -124 : 124;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 40);
        if ((value & 0xFFFF000000000000L) == 0L) {
            buf[byte1Off] = negative ? -125 : 125;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 48);
        if ((value & 0xFF00000000000000L) == 0L) {
            buf[byte1Off] = negative ? -126 : 126;
            return offset;
        }
        buf[offset++] = (byte)(value >>> 56);
        buf[byte1Off] = negative ? -127 : 127;
        return offset;
    }

    public static int getWriteIntLength(int value) {
        if (value < -119) {
            value = -value - 119;
        } else if (value > 119) {
            value -= 119;
        } else {
            return 1;
        }
        if ((value & 0xFFFFFF00) == 0) {
            return 2;
        }
        if ((value & 0xFFFF0000) == 0) {
            return 3;
        }
        if ((value & 0xFF000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int getWriteLongLength(long value) {
        if (value < -119L) {
            value = -value - 119L;
        } else if (value > 119L) {
            value -= 119L;
        } else {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFFF00L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFFF0000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFFF000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFFF00000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFF0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFF000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        return 9;
    }
}

