package csl.tools.weka;

import weka.classifiers.Classifier;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.functions.supportVector.RBFKernel;
import weka.classifiers.lazy.IBk;
import weka.classifiers.trees.J48;

public abstract class ClassifierFactory {

	String	SVM_CLASS_NAME	= "weka.classifiers.functions.SMO";
	String	KNN_CLASS_NAME	= "weka.classifiers.lazy.IBk";
	String	J48_CLASS_NAME	= "weka.classifiers.trees.J48";

	static public SMO smoLinear() {

		return new SMO();
	}

	static public SMO smoRBF() {

		SMO smo = new SMO();
		smo.setKernel(new RBFKernel());
		return smo;
	}

	static public SMO smoQuadratic() {

		SMO smo = new SMO();
		PolyKernel ker = new PolyKernel();
		ker.setExponent(2);
		smo.setKernel(ker);
		return smo;
	}

	static public J48 j48() {

		return new J48();
	}

	static public IBk ibk(int k) {

		return new IBk(k);
	}

	public static Classifier fromString(String s) {

		s = s.toLowerCase();
		s = s.replace("svm", "smo");
		if (s.equals("smo") || s.equals("smo linear")
				|| s.equals("smo gaussian"))
			return smoLinear();

		if (s.equals("smo") || s.equals("smo quadratic")
				|| s.equals("smo quad"))
			return smoQuadratic();
		if (s.equals("rbf") || s.equals("smorbf") || s.equals("smo rbf"))
			return smoRBF();
		if (s.equals("j48"))
			return j48();
		if (s.startsWith("ib")) {
			Integer k = Integer.parseInt(s.substring(2));
			return ibk(k);
		}
		if (s.endsWith("nn")) {
			Integer k = Integer.parseInt(s.substring(0, s.length() - 2));
			return ibk(k);
		}
		return null;
	}

	public static void main(String[] args) throws Exception {

		Classifier classifier = Classifier.forName(
				"weka.classifiers.functions.SMO", null);
		System.out.println(classifier);
	}
}
