package csl.tools.gui;

import java.io.PrintStream;

public class TextProgress {

	int			dotFreq		= 1;
	int			plusFreq	= 10;
	int			crFreq		= 100;
	int			max			= -1;
	PrintStream	stream		= System.out;
	int			count		= 0;

	public TextProgress(int dot, int plus, int cr, int max) {

		this.dotFreq = dot;
		this.plusFreq = plus;
		this.crFreq = cr;
		this.max = max;
	}

	TextProgress(int dot, int plus, int cr, int max, PrintStream s) {

		this(dot, plus, cr, max);
		this.stream = s;
	}

	public TextProgress() {

		this(1, 10, 100, -1);
	}

	public TextProgress(int max) {

		this(1, 10, 100, max);
	}

	public void accept(int count) {

		if (count % crFreq == 0) {
			stream.println("\t" + count + (max > 0 ? " / " + max : " / ?"));
		} else if (count % plusFreq == 0)
			stream.print("+");
		else if (count % dotFreq == 0)
			stream.print(".");
	}

	public void next() {

		accept(++count);
	}

	public void accept() {

		accept(++count);
	}

	public void reset() {

		count = 0;
	}
}
