package csl.tools.gui;

import java.awt.BorderLayout;

import javax.swing.JComboBox;
import javax.swing.JPanel;

public class RecentItemSingleSelectionPanel<I> extends JPanel {

	private static final long	serialVersionUID	= -3781122948979323755L;
	
	JComboBox itemListComboBox = null;

	/**
	 * This is the default constructor
	 */
	public RecentItemSingleSelectionPanel() {

		super();
		initialize();
	}
	
	public void setModel(RecentItemListManager<I> m) {
		
		itemListComboBox.setModel(m);
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {

		this.setLayout(new BorderLayout());
		this.setSize(300, 26);
		this.add(getItemListComboBox(), java.awt.BorderLayout.CENTER);
	}

	/**
	 * This method initializes itemListComboBox	
	 * 	
	 * @return javax.swing.JComboBox	
	 */
	private JComboBox getItemListComboBox() {
	
		if (itemListComboBox == null) {
			itemListComboBox = new JComboBox();
		}
		return itemListComboBox;
	}

	protected RecentItemListManager<I> getModel() {

		return (RecentItemListManager<I>) itemListComboBox.getModel();
	}

}  //  @jve:decl-index=0:visual-constraint="10,10"
