package csl.tools.experiments;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class ThreadPool {

	private static ThreadPool		instance	= new ThreadPool();

	private int						size		= 0;
	private int						minSize		= 5;
	private int						maxSize		= 7;
	private int						increment	= 5;
	private List<ThreadDecorator>	freeThreads	= new ArrayList<ThreadDecorator>(
														minSize);

	public static ThreadPool getInstance() {

		return instance;
	}

	public void stopASAP() {

		for (ThreadDecorator dec : freeThreads)
			dec.stopASAP();
	}

	private int addNewThreads(int nThreads) {

		int added = 0;
		for (int i = 0; i < nThreads; i++) {
			if (size < maxSize) {
				freeThreads.add(new ThreadDecorator(this));
				++added;
				++size;
			}
		}
		return added;
	}

	public ThreadDecorator getThread() {

		return (freeThreads.size() == 0 && addNewThreads(increment) == 0) ? null
				: freeThreads.remove(0);
	}

	public void frees(ThreadDecorator th) {

		freeThreads.add(th);
	}

	public void increaseSize() {

		size++;
	}

	public static void main(String[] args) {

		final Random r = new Random();
		ThreadPool pool = ThreadPool.getInstance();
		pool.addNewThreads(15);
		String[] items = new String[] { "one", "two", "three", "four", "five",
				"six", "seven", "eight", "nine", "ten", "twelve", "eleven",
				"thirteen" };
		final List<String> done = new ArrayList<String>(items.length);
		for (final String item : items) {

			ThreadDecorator dec = null;
			while (dec == null)
				dec = pool.getThread();
			Runnable run = new Runnable() {

				public void run() {

					System.out.println(item + " started");
					try {
						Thread.sleep(r.nextInt(100));
					} catch (InterruptedException e) {
						e.printStackTrace();
					}
					System.out.println(item + " done");
					done.add(item);
				}
			};
			dec.setDelegate(run);
		}
		while (done.size() < items.length)
			;

		pool.stopASAP();
	}

}
